#include "spi.h"


SPI LpmsBE1_SPI(SPI_MOSI, SPI_MISO, SPI_SCK);
DigitalOut LpmsBE1_CS(SPI_CS);


void LpmsBE1_SPI_Init()
{
    LpmsBE1_SPI.format(8, 0);
    LpmsBE1_SPI.frequency(SPI_FREQUENCY);
}



void LpmsBE1_get_timestamp(uint32_t *ts)
{
    uint8_t data_buf[4] = { 0 };
    LpmsBE1_SPI_Read(0x20, data_buf, 4);
    *ts = uint8_to_uint32(data_buf);
}

void LpmsBE1_get_acc(float *acc)
{
    uint8_t buf[12] = { 0 };
    LpmsBE1_SPI_Read(0x24, buf, 12);
    for (int i = 0; i < 3; i++)
        acc[i] = uint8_to_float(&buf[i*4]);
}


uint32_t uint8_to_uint32(uint8_t *pu8vals)
{
    DataDecoder decoder;
    for(int i = 0; i < 4; i++)
    {
        decoder.u8vals[i] = *(pu8vals +i);
    }
    return decoder.u32val;
}

float uint8_to_float(uint8_t *pu8vals)
{
    DataDecoder decoder;
    for(int i = 0; i < 4; i++)
    {
        decoder.u8vals[i] = *(pu8vals +i);
    }
    return decoder.fval;
}

void LpmsBE1_SPI_Write(uint8_t addr, uint8_t *buf, uint8_t length)
{
    LpmsBE1_SPI.lock();
    LpmsBE1_CS = 0;
    wait_us(50);

    uint8_t temp = 0xFF;
    addr &= ~0x80;
    LpmsBE1_SPI.write(addr);
    wait_us(50);
    LpmsBE1_SPI.write((char*)buf, length, (char*)temp, 0);
    wait_us(50);

    LpmsBE1_CS = 1;
    LpmsBE1_SPI.unlock();
}

void LpmsBE1_SPI_Read(uint8_t addr, uint8_t *buf, uint8_t length)
{
    LpmsBE1_SPI.lock();
    LpmsBE1_CS = 0;
    wait_us(50);

    uint8_t temp = 0xFF;
    addr |= 0x80;
    LpmsBE1_SPI.write(addr);
    wait_us(50);
    LpmsBE1_SPI.write((char*)temp, 0, (char*)buf, length);
    wait_us(50);

    LpmsBE1_CS = 1;
    LpmsBE1_SPI.unlock();
}
