//******************************************************************************************************
//Aufgabenstellung:

//BERTL fährt nach vorne bis einer der vorderen Taster einen Widerstand erkennt, dann fährt er zurück.
//BERTL fährt rückwärts bis einer der hinteren Taster einen Widerstand erkennt, dann fährt er nach vorne.
//Wenn der BERTL eingeklemmt ist (Tasten sind vorne und hinten aktiviert), dann fährt er nicht.

//Zusätzlich:
//Wenn der BERTL nach vorne fährt, sollen alle vorderen LEDs (D1, D2, D4, D5) leuchten,
//wenn er nach rückwärts fährt, sollen alle hinteren LEDs (D6 - D9) leuchten.
//Wenn er gar nicht fährt, dann sind die LEDs aus.
//********************************************************************************************************

#include "mbed.h"
#include "bertl14.h"

int main() 
{
    int taster;
    bertl_PC9555_init();
    //Start BERTL-PING-PONG
    //Begin to drive FORWARD
    bertl_engine(100,100);
    bertl_PC9555_leds(LED_F_ALL);
    while(true)
    {
        // Get the value

        taster =  bertl_PC9555_switches();
        // If the Forward switches are pressed, the BERTL change his direction and drive REVERSE
        // The Backward LEDs turn on 
        if(taster == 4 || taster == 1 || taster == 8 || taster == 5 || taster == 12 || taster == 9 || taster == 13)// => see bertl14.h
        {
            bertl_engine(-100, -100);
            bertl_PC9555_leds(LED_B_ALL);
        }
        // If the Backward switches are pressed, the BERTL change his direction and drive FORWARD
        // The Forward LEDs turn on 
        else if(taster == 16 || taster == 2 || taster == 32 || taster == 18 || taster == 48 || taster == 34 || taster == 50)// => see bertl14.h
        {  
            bertl_engine(100,100);
            bertl_PC9555_leds(LED_F_ALL);
        }
        // If switches on both sites are pressed, the BERTL stop driving and ALL LEDs are off
        else if(taster != 0)
        {
            bertl_engine(0,0);
            bertl_PC9555_leds(LED_OFF);
        }
    }
    //END BERTL-PING-PONG
}
