#ifndef MAIN_H
#define MAIN_H

#include "alpha433.h"

#define SWARM_SIZE 32
#define USE_COMMUNICATION_STACK 1
#define PC_BAUD 115200
#define RF_ALLOW_COMMANDS 1
#define RF_USE_LEDS 1
#define RF_USE_TDMA 1
#define RF_TDMA_TIME_PERIOD_US 15625
#define RF_DEBUG 1
#define RF_VERBOSE 1
#define START_RADIO_ON_BOOT 1
#define RF_FREQUENCY 435000000
#define RF_DATARATE 57600

extern Serial pc;
extern Alpha433 rf;


void init ( void );
void broadcast_user_rf_command(int function, char * message, int length);
void handleUserRFResponse(char sender, char broadcast_message, char success, char id, char is_command, char function, char * data, char length);
void handleUserRFCommand(char sender, char broadcast_message, char request_response, char id, char is_command, char function, char * data, char length);
 
void processRawRFData(char * rstring, char cCount);
void check_switch(void);
void setup_switches(void);
void transmit_message(void);
void handleData(char * data, char length);


#endif // MAIN_H
