#include "mbed.h"
//#include "filter_characteristics.h"
#define ON      1
#define OFF     0

#define Fs      6000
#define N       37
float x[N]={0};
float yn;
Timer t;
void sampler(void);                     
DigitalOut SampLED(LED1);               
DigitalOut testpin(D8);
AnalogIn  Ain(A1);                    
AnalogOut Aout(A2);                    
Ticker sample_timer;                    
PwmOut test(D9);


float b[N]={-0.000000, -0.000684, 0.001238, -0.000000, -0.003098, 0.004522, -0.000000, -0.008736, 0.011729, -0.000000, -0.020268, 0.026356, -0.000000, -0.045082, 0.060638, -0.000000, -0.133528, 0.273491,  0.666667, 0.273491, -0.133528, -0.000000, 0.060638, -0.045082, -0.000000, 0.026356, -0.020268, -0.000000, 0.011729, -0.008736, -0.000000, 0.004522, -0.003098, -0.000000, 0.001238, -0.000684, -0.000000};



int main() {
    float duty=0.1f;//
    test.period_ms(1);
    test=duty;
    float sample_rate=(1.0/Fs)*1000000.0;    //             
    sample_timer.attach_us(&sampler,(int)sample_rate);  
    while(1) {
        sleep();
    }
}
void sampler(void){                     
    SampLED = ON;                       
    int i;                              
    testpin = 1;
    x[0]=Ain;                          
    yn=0.0;                             
    for(i=0; i<N; i++) yn+=(x[i]*b[i])*20;   
    for(i=N-1; i!=0; i--) x[i]=x[i-1];  
    Aout=yn;                           
    testpin = 0;
    SampLED = OFF;                      
    }
