#include "mbed.h"
//#include "TextLCD.h"
//#include "SDFileSystem.h"

#define GAIN_TOPDEF 6
#define SIGN_TOPDEF 5
#define GAIN_BOTDEF 4
#define SIGN_BOTDEF 3
#define GAIN_TOPPLATE 2
#define SIGN_TOPPLATE 1
#define GAIN_ANL 0

//#define LPC1768
//#define K64F
//#define KL25Z
#define F746ZG

Serial pc(USBTX, USBRX);
#ifdef LPC1768
DigitalOut led1(LED1),led2(LED2);
TextLCD lcd(p15, p16, p17, p18, p19, p20, TextLCD::LCD16x2); // rs, e, d4-d7
SDFileSystem sd(p5, p6, p7, p8, "sd"); // the pinout on the mbed Cool Components workshop board
SPI spi(p11, p12, p13); // MOSI (Din DAC), MISO (Dout ADC), SCLK
DigitalOut on_off_mhv(p21), cs_adc(p22), sign_top_def(p25), gain_top_def(p26), cs_top_def(p23), cs_mhv(p24);
#endif
#ifdef K64F
SPI spi(D11, D12, D13); // MOSI (Din DAC), MISO (Dout ADC), SCLK
DigitalOut on_off_mhv(PTB18), cs_adc(PTC17), sign_top_def(PTC1), gain_top_def(PTC8), cs_top_def(PTC9), cs_mhv(D9);
DigitalOut gain_anl(D0), cs_anl(PTB19), sign_top_plate(D2), gain_top_plate(D3), cs_top_plate(D4);
DigitalOut sign_bot_def(D5), gain_bot_def(D6), cs_bot_def(D7), hv_limit(D10);
DigitalOut led_green(LED2); //  GREEN
DigitalOut led_red(LED1); //  RED
DigitalOut led_blue(LED3); //  BLUE
#endif
#ifdef F746ZG
SPI spi(D11, D12, D13); // MOSI (Din DAC), MISO (Dout ADC), SCLK
DigitalOut on_off_mhv(PB_2), cs_adc(D1), sign_top_def(PF_4), gain_top_def(PC_2), cs_top_def(PB_1), cs_mhv(D9);
DigitalOut gain_anl(D0), cs_anl(PB_6), sign_top_plate(D2), gain_top_plate(D3), cs_top_plate(D4);
DigitalOut sign_bot_def(D5), gain_bot_def(D6), cs_bot_def(D7), hv_limit(D10);
DigitalOut led_green(LED2); //  GREEN
DigitalOut led_red(LED1); //  RED
DigitalOut led_blue(LED3); //  BLUE
#endif
#ifdef KL25Z
SPI spi(PTD2, PTD3, PTD1); // MOSI (Din DAC), MISO (Dout ADC), SCLK
DigitalOut on_off_mhv(PTC7), cs_adc(PTA1), sign_top_def(PTC3), gain_top_def(PTC4), cs_top_def(PTC5), cs_mhv(PTC6);
DigitalOut gain_anl(PTA2), cs_anl(PTC0), sign_top_plate(PTD4), gain_top_plate(PTA12), cs_top_plate(PTA4);
DigitalOut sign_bot_def(PTA5), gain_bot_def(PTC8), cs_bot_def(PTC9), hv_limit(PTC11);
DigitalOut led_green(LED2); //  GREEN
DigitalOut led_red(LED1); //  RED
DigitalOut led_blue(LED3); //  BLUE
#endif

struct hv {
    short top_def, bot_def, top_plate, anl;
    char gain_sign;
    struct hv *next;
} *head, *tail, *node, *temp;
typedef struct hv element;

Ticker sweeper;

void sweep(void);
void load_dac_gain_sign(element *tail);
void libere_memoire();

int main()
{
    char c, on, byte[4] = {0};
    short mhv = 0, dac = 0;
    int dwell = 1000000;    // interval between steps in microsec
//    short adc = 0, gbot_def, sbot_def, gtop_plate, stop_plate, ganl;
    short nb_elts = 0;
    int adc = 0;
    short adc0 = 0, adc1 = 0;
    bool clean = false;
    unsigned int checksum = 0;
    short ok = 0xcc;
//    char texte[128];

#ifdef LPC1768
    led1 = 0;
    led2 = 0;
#endif

#ifdef K64F
    led_red = true;
    led_green = true;
    led_blue = true;
#endif

//    int step = 10;    // increment pour les DACs
    // initialisations
    on_off_mhv = 0;   // mhv off
    cs_adc = 1;   // adc not selected
    cs_anl = 1;
    cs_bot_def = 1;
    cs_top_plate = 1;
    cs_top_def = 1;   // dac anl not selected
    cs_mhv = 1;   // dac mhv not selected
    gain_anl = 0;   // low gain
    gain_top_def = 0;  // low gain
    gain_bot_def = 0;
    gain_top_plate = 0;
    sign_top_def = 1;  // positif
    sign_bot_def = 0;  // negatif
    sign_top_plate = 1;  // positif

    spi.format(16,1);   //  setup for SPI DAC, 16 bit data, high steady state clock, second edge capture
//    spi.frequency(1000000);   // 1 MHz SPI clock
    spi.frequency(100000);   // 100 kHz SPI clock

//   pc.baud(9600);    // set baud rate for RS232
    pc.baud(115200);
    pc.format(8, SerialBase::None, 1);    // 8 bits data, no parity bit, 1 stop bit


#ifdef LPC1768
    if (sign_top_def == 1) s = '+';
    else s = '-';
    if (gain_top_def == 1) g = 'H';
    else g = 'L';
    if (on_off_mhv == 0) on = 'A';
    else on = 'M';
    lcd.cls();          // clear the LCD screen
    lcd.locate(13,0);   // locate to column 13, row 0
    lcd.printf("%c%c%c", g, s, on);
    lcd.locate(0,1);   // locate to column 0, row 1
    lcd.printf("MHV %4d AN %4d", mhv, anl);
#endif
    while (1) {
        c = pc.getc();
        if (c == 0x01) {
            pc.puts("Connexion OK\r\n");
#ifdef LPC1768
            led1 = 1;
#endif
        }
        if (c == 0x02) {        // load DAC, gain and sign values
#ifdef K64F
//            led_green = false;    // allume la LED verte
#endif
            if (clean) {
                nb_elts = 0;
                ok = 0xcc;
                libere_memoire();
                clean = false;
#ifdef K64F
                led_green = false;    // allume la LED verte
#endif
            }

#ifdef LPC1768
            led2 =!led2;
#endif
#ifdef K64F
//            led_green = !led_green;    // LED verte clignote
#endif
            // renvoie la commande pour signaler qu'on est prêt à recevoir les données
            pc.putc(0x02);
            checksum = 0;
            if (nb_elts == 0) {
                byte[0] = pc.getc();   // MSB
                byte[1] = pc.getc();   // LSB
                if (ok == 0xcc) head = (element*)malloc(sizeof(element));
                head->top_def = (byte[0] << 8) | byte[1];
                checksum += head->top_def;
                byte[0] = pc.getc();    // MSB
                byte[1] = pc.getc();    // LSB
                head->bot_def = (byte[0] << 8) | byte[1];
                checksum += head->bot_def;
                byte[0] = pc.getc();     // MSB
                byte[1] = pc.getc();     // LSB
                head->top_plate = (byte[0] << 8) | byte[1];
                checksum += head->top_plate;
                byte[0] = pc.getc();     // MSB
                byte[1] = pc.getc();     // LSB
                head->anl = (byte[0] << 8) | byte[1];
                checksum += head->anl;
#ifdef LPC1768
                lcd.cls();
                lcd.locate(0, 1);
                lcd.printf("%4x%4x%4x%4x",head->top_def,head->bot_def,head->top_plate,head->anl);
#endif
                byte[0] = pc.getc();
                checksum += byte[0];
                head->gain_sign = byte[0];
#ifdef LPC1768
                lcd.locate(0, 0);    // columb 0, row 0
                lcd.printf("%04x",head->gain_sign);
#endif
                tail = head;
                // renvoyer le checksum
                byte[0] = checksum & 0xff;    // LSB
                pc.putc(byte[0]);
                byte[1] = (checksum >> 8) & 0xff;    // MSB
                pc.putc(byte[1]);
                byte[0] = (checksum >> 16) & 0xff;
                pc.putc(byte[0]);
                byte[1] = (checksum >> 24) & 0xff;
                pc.putc(byte[1]);
                // attendre la réponse: si Ok attendre 0xcc, si Nok attendre 0x33
                ok = pc.getc();
                if (ok == 0xcc) nb_elts = 1;
            } else {
                if (ok == 0xcc) {
                    tail->next = (element*)malloc(sizeof(element));
                    tail = tail->next;    // avance d'un pas
                }
                byte[0] = pc.getc();
                byte[1] = pc.getc();
                tail->top_def = (byte[0] << 8) | byte[1];
                checksum += tail->top_def;
                byte[0] = pc.getc();
                byte[1] = pc.getc();
                tail->bot_def = (byte[0] << 8) | byte[1];
                checksum += tail->bot_def;
                byte[0] = pc.getc();
                byte[1] = pc.getc();
                tail->top_plate = (byte[0] << 8) | byte[1];
                checksum += tail->top_plate;
                byte[0] = pc.getc();
                byte[1] = pc.getc();
                tail->anl = (byte[0] << 8) | byte[1];
                checksum += tail->anl;
                byte[0] = pc.getc();
                checksum += byte[0];
                tail->gain_sign = byte[0];
#ifdef LPC1768
                lcd.cls();
                lcd.locate(0, 1);
                lcd.printf("%4x%4x%4x%4x",tail->top_def,tail->bot_def,tail->top_plate,tail->anl);
                lcd.locate(15, 0);    // columb 15, row 0
                lcd.printf("%2x",tail->gain_sign);
#endif

                // renvoyer le checksum
                byte[0] = checksum & 0xff;    // LSB
                pc.putc(byte[0]);
                byte[1] = (checksum >> 8) & 0xff;    // MSB
                pc.putc(byte[1]);
                byte[0] = (checksum >> 16) & 0xff;
                pc.putc(byte[0]);
                byte[1] = (checksum >> 24) & 0xff;
                pc.putc(byte[1]);
                // attendre la réponse: si Ok attendre 0xcc, si Nok attendre 0x33
                ok = pc.getc();
                if (ok == 0xcc) nb_elts++;
                tail->next = NULL;
            }
#ifdef K64F
//            led_green = true;    // éteint la LED verte
#endif
        }
        if ( c == 0x03) {    // send the number of elements loaded in memory
#ifdef LPC1768
            lcd.locate(0, 0);
            lcd.printf("Nb of elts: %4d",nb_elts);
#endif
            byte[0] = nb_elts & 0xff;    // LSB
            pc.putc(byte[0]);
            byte[1] = nb_elts >> 8;    // MSB
            pc.putc(byte[1]);
            // positionne en début de liste
            tail = head;
            // Set DACs gain & sign
            spi.format(16,1);
            load_dac_gain_sign(tail);
            clean = true;
#ifdef K64F
            led_green = true;    // éteint la LED verte
#endif

        }
        if ( c == 0x04) {    // receive the DAC MHV and returns it
            byte[1] = pc.getc();     // LSB received
            byte[0] = pc.getc();     // MSB received
            mhv = (byte[0] << 8) | byte[1];
#ifdef LPC1768
            lcd.locate(0, 0);
            lcd.printf("MHV : %04d  %02x  ",mhv,tail->gain_sign);
#endif
            pc.putc(byte[1]);     // LSB sent
            pc.putc(byte[0]);     // MSB sent

            spi.format(16,1);    // format to write into DAC
            cs_mhv = 0;
            spi.write(mhv);    // send value to DAC MHV
            cs_mhv = 1;
        }
        if ( c == 0x05) {    // avance d'un pas
#ifdef K64F
//            led_blue = false;    // allume la LED
#endif
            tail = tail->next;
#ifdef LPC1768
            lcd.locate(0, 1);
            lcd.printf("%4x%4x%4x%4x",tail->top_def,tail->bot_def,tail->top_plate,tail->anl);
#endif
            // configure DAC with top_def value, gain and sign
            spi.format(16,1);
            load_dac_gain_sign(tail);
#ifdef K64F
//            led_blue = true;    // éteint la LED
#endif
        }
        if ( c == 0x06) {    // recule d'un pas
#ifdef K64F
//            led_red = false;    // allume la LED
#endif
            node = head;
            if (tail != head) {
                while (node->next != tail)   node = node ->next;
                tail = node;    // recule d'un pas dans la liste
            }
#ifdef LPC1768
            lcd.locate(0, 1);
            lcd.printf("%4x%4x%4x%4x",tail->top_def,tail->bot_def,tail->top_plate,tail->anl);
#endif
            // configure DAC with top_def value, gain and sign
            spi.format(16,1);
            load_dac_gain_sign(tail);
#ifdef K64F
//            led_red = true;    // éteint la LED
#endif
        }
        if ( c == 0x07) {    // set DAC values, gain & sign
            spi.format(16,1);
            load_dac_gain_sign(tail);
#ifdef LPC1768
            lcd.locate(0, 1);
            lcd.printf("%4x%4x%4x%4x",tail->top_def,tail->bot_def,tail->top_plate,tail->anl);
            lcd.locate(14, 0);
            lcd.printf("%02x",tail->gain_sign);
#endif
        }
        if ( c == 0x08) {     // receive DAC top def value and reloads top def DAC
            byte[1] = pc.getc();    // LSB received
            byte[0] = pc.getc();    // MSB received
            dac = (byte[0] << 8) | byte[1];
            spi.format(16,1);
            cs_top_def = 0;
            spi.write(dac);   // send value to DAC
            cs_top_def = 1;
        }
        if ( c == 0x09) {
            tail = head;      // set pointer to beginning of list
#ifdef LPC1768
            lcd.locate(0, 1);
            lcd.printf("%4x%4x%4x%4x",tail->top_def,tail->bot_def,tail->top_plate,tail->anl);
#endif
            spi.format(16,1);
            load_dac_gain_sign(tail);
        }
        if ( c == 0x0a) {
            tail->gain_sign = pc.getc();    // gain & sign received
            gain_top_def = ((tail->gain_sign) >> GAIN_TOPDEF) & 0x01;
            sign_top_def = ((tail->gain_sign) >> SIGN_TOPDEF) & 0x01;
            gain_bot_def = ((tail->gain_sign) >> GAIN_BOTDEF) & 0x01;
            sign_bot_def = ((tail->gain_sign) >> SIGN_BOTDEF) & 0x01;
            gain_top_plate = ((tail->gain_sign) >> GAIN_TOPPLATE) & 0x01;
            sign_top_plate = ((tail->gain_sign) >> SIGN_TOPPLATE) & 0x01;
            gain_anl = ((tail->gain_sign) >> GAIN_ANL) & 0x01;
            //lcd.locate(14, 0);    // column 15, row 0
            //lcd.printf("%2x",tail->gain_sign);
        }
        if ( c == 0x0b) {    // receive On/Off value and set it
            on = pc.getc();
            on_off_mhv = on;    // set on(1) / off(0) MHV
        }
        if ( c == 0x0c) {  // send ADC values
#ifdef F746ZG
            spi.format(16,3);    // format pour l'ADC
//            spi.format(8,3);

            // faire une lecture bidon sans sélectionner l'ADC
            spi.write(0);
            cs_adc = 0;

//            adc = spi.write(0);

            adc = spi.write(0x0800);  // lecture adc in0    (HK_TEMP_HVPS)
            adc1 = adc >> 8;     // MSB part
            adc0 = adc & 0xff;   // LSB part
 //           adc1 = spi.write(0x8);    // lecture adc in0    (HK_TEMP_HVPS)          
 //           adc0 = spi.write(0);
            pc.putc(adc1);     // send MSB  in0
            pc.putc(adc0);     // send LSB  in0   

            adc = spi.write(0x1000);  // lecture adc in1
            adc1 = adc >> 8;     // MSB part
            adc0 = adc & 0xff;   // LSB part
 //           adc1 = spi.write(0x10);   // lecture adc in1   (HK_TEMP_EA)  
 //           adc0 = spi.write(0);
            pc.putc(adc1);     // send MSB adc
            pc.putc(adc0);      // send LSB adc
            
            adc = spi.write(0x1800);  // lecture adc in2    (HK_TEMP_HVPS)
            adc1 = adc >> 8;     // MSB part
            adc0 = adc & 0xff;   // LSB part
//            adc1 = spi.write(0x18);    // lecture adc in2   (HK_MHV_POS)
//            adc0 = spi.write(0); 
            pc.putc(adc1);     // send MSB adc
            pc.putc(adc0);      // send LSB adc
            
            adc = spi.write(0x2000);  // lecture adc in3    (HK_TEMP_HVPS)
            adc1 = adc >> 8;     // MSB part
            adc0 = adc & 0xff;   // LSB part
//            adc1 = spi.write(0x20);   // lecture adc in3   (HK_MHV_NEG)
//            adc0 = spi.write(0);
            pc.putc(adc1);     // send MSB adc
            pc.putc(adc0);      // send LSB adc
            
            adc = spi.write(0x2800);  // lecture adc in4    (HK_TEMP_HVPS)
            adc1 = adc >> 8;     // MSB part
            adc0 = adc & 0xff;   // LSB part
//            adc1 = spi.write(0x28);    // lecture adc in4   (HK_ANL)
//            adc0 = spi.write(0); 
            pc.putc(adc1);     // send MSB adc
            pc.putc(adc0);      // send LSB adc
            
            adc = spi.write(0x3000);  // lecture adc in5    (HK_TEMP_HVPS)
            adc1 = adc >> 8;     // MSB part
            adc0 = adc & 0xff;   // LSB part
 //           adc1 = spi.write(0x30);    // lecture adc in5   (HK_TOP_DEF)           
 //           adc0 = spi.write(0);
            pc.putc(adc1);     // send MSB adc
            pc.putc(adc0);      // send LSB adc
            
            adc = spi.write(0x3800);  // lecture adc in6    (HK_TEMP_HVPS)
            adc1 = adc >> 8;     // MSB part
            adc0 = adc & 0xff;   // LSB part
 //           adc1 = spi.write(0x38);    // lecture adc in6   (HK_BOT_DEF)           
 //           adc0 = spi.write(0);  
            pc.putc(adc1);     // send MSB adc
            pc.putc(adc0);      // send LSB adc
            
            adc = spi.write(0x0);  // lecture adc in7    (HK_TEMP_HVPS)
            adc1 = adc >> 8;     // MSB part
            adc0 = adc & 0xff;   // LSB part
 //           adc1 = spi.write(0);     // lecture adc in7  (HK_TOP_PLT)  finit sur 0 pour démarrer par in0
 //           adc0 = spi.write(0); 
            pc.putc(adc1);     // send MSB adc
            pc.putc(adc0);      // send LSB adc
            cs_adc = 1;
#endif
#ifdef K64F
//            spi.format(16,3);    // format pour l'ADC
            spi.format(8,3);

            // faire une lecture bidon sans sélectionner l'ADC
            spi.write(0);
            cs_adc = 0;

            adc = spi.write(0);

//            adc = spi.write(0x0800);  // lecture adc in0    (HK_TEMP_HVPS)
//            adc1 = adc >> 8;     // MSB part
//            adc0 = adc & 0xff;   // LSB part
            adc1 = spi.write(0x8);    // lecture adc in0    (HK_TEMP_HVPS)          
            adc0 = spi.write(0);
            pc.putc(adc1);     // send MSB  in0
            pc.putc(adc0);     // send LSB  in0   

//            adc = spi.write(0x1000);  // lecture adc in1
//            adc1 = adc >> 8;     // MSB part
//            adc0 = adc & 0xff;   // LSB part
            adc1 = spi.write(0x10);   // lecture adc in1   (HK_TEMP_EA)  
            adc0 = spi.write(0);
            pc.putc(adc1);     // send MSB adc
            pc.putc(adc0);      // send LSB adc
            
//            adc = spi.write(0x1800);  // lecture adc in2    (HK_TEMP_HVPS)
//            adc1 = adc >> 8;     // MSB part
//            adc0 = adc & 0xff;   // LSB part
            adc1 = spi.write(0x18);    // lecture adc in2   (HK_MHV_POS)
            adc0 = spi.write(0); 
            pc.putc(adc1);     // send MSB adc
            pc.putc(adc0);      // send LSB adc
            
//            adc = spi.write(0x2000);  // lecture adc in3    (HK_TEMP_HVPS)
//            adc1 = adc >> 8;     // MSB part
//            adc0 = adc & 0xff;   // LSB part
            adc1 = spi.write(0x20);   // lecture adc in3   (HK_MHV_NEG)
            adc0 = spi.write(0);
            pc.putc(adc1);     // send MSB adc
            pc.putc(adc0);      // send LSB adc
            
//            adc = spi.write(0x2800);  // lecture adc in4    (HK_TEMP_HVPS)
//            adc1 = adc >> 8;     // MSB part
//            adc0 = adc & 0xff;   // LSB part
            adc1 = spi.write(0x28);    // lecture adc in4   (HK_ANL)
            adc0 = spi.write(0); 
            pc.putc(adc1);     // send MSB adc
            pc.putc(adc0);      // send LSB adc
            
//            adc = spi.write(0x3000);  // lecture adc in5    (HK_TEMP_HVPS)
//            adc1 = adc >> 8;     // MSB part
//            adc0 = adc & 0xff;   // LSB part
            adc1 = spi.write(0x30);    // lecture adc in5   (HK_TOP_DEF)           
            adc0 = spi.write(0);
            pc.putc(adc1);     // send MSB adc
            pc.putc(adc0);      // send LSB adc
            
//            adc = spi.write(0x3800);  // lecture adc in6    (HK_TEMP_HVPS)
//            adc1 = adc >> 8;     // MSB part
//            adc0 = adc & 0xff;   // LSB part
            adc1 = spi.write(0x38);    // lecture adc in6   (HK_BOT_DEF)           
            adc0 = spi.write(0);  
            pc.putc(adc1);     // send MSB adc
            pc.putc(adc0);      // send LSB adc
            
//            adc = spi.write(0x0);  // lecture adc in7    (HK_TEMP_HVPS)
//            adc1 = adc >> 8;     // MSB part
//            adc0 = adc & 0xff;   // LSB part
            adc1 = spi.write(0);     // lecture adc in7  (HK_TOP_PLT)  finit sur 0 pour démarrer par in0
            adc0 = spi.write(0); 
            pc.putc(adc1);     // send MSB adc
            pc.putc(adc0);      // send LSB adc
            cs_adc = 1;
#endif
            spi.format(16,1);    // format to write into DAC
            // faire une lecture bidon sans sélectionner l'ADC
            spi.write(0);
        }
        if ( c == 0x0d) {  // load the dwell time in us
            byte[1] = pc.getc();     // LSB received
            byte[0] = pc.getc();     // MSB received
            byte[3] = pc.getc();     // LSB
            byte[2] = pc.getc();     // MSB
            dwell = (((byte[2] << 24) | byte[3]) << 16) | ((byte[0] << 8) | byte[1]);
#ifdef LPC1768
            lcd.locate(0, 0);
            lcd.printf("Dwell : %8d",dwell);
#endif
            pc.putc(byte[1]);     // LSB sent
            pc.putc(byte[0]);     // MSB sent
            pc.putc(byte[3]);     // LSB sent
            pc.putc(byte[2]);     // MSB sent
        }
        if ( c == 0x0e) {   // start sweeping
            spi.format(16,1);    // ecrire dans les DACs
            sweeper.attach_us(&sweep,dwell);
        }
        if ( c == 0x0f) {   // stop sweeping
            sweeper.detach();
        }
        if ( c == 0x10) {     // receive DAC analyzer value and reloads analyzer DAC
            byte[1] = pc.getc();    // LSB received
            byte[0] = pc.getc();    // MSB received
            dac = (byte[0] << 8) | byte[1];
            spi.format(16,1);
            cs_anl = 0;
            spi.write(dac);   // send value to DAC
            cs_anl = 1;
        }
        if ( c == 0x11) {     // receive DAC bot def value and reloads bot def DAC
            byte[1] = pc.getc();    // LSB received
            byte[0] = pc.getc();    // MSB received
            dac = (byte[0] << 8) | byte[1];
            spi.format(16,1);
            cs_bot_def = 0;
            spi.write(dac);   // send value to DAC
            cs_bot_def = 1;
        }
        if ( c == 0x12) {     // receive DAC top plate value and reloads top plate DAC
            byte[1] = pc.getc();    // LSB received
            byte[0] = pc.getc();    // MSB received
            dac = (byte[0] << 8) | byte[1];
            spi.format(16,1);
            cs_top_plate = 0;
            spi.write(dac);   // send value to DAC
            cs_top_plate = 1;
        }
    }    // end while (1)

}   // end main

void sweep()
{
    if (tail->next != NULL) {
        tail = tail->next;      // avance d'un pas
    } else tail = head;     // revient au début
    load_dac_gain_sign(tail);
}    // end sweep()

void load_dac_gain_sign(element *tail)
{
    gain_top_def = ((tail->gain_sign) >> GAIN_TOPDEF) & 0x01;
    sign_top_def = ((tail->gain_sign) >> SIGN_TOPDEF) & 0x01;
    cs_top_def = 0;
    spi.write(tail->top_def);   // send value to DAC
    cs_top_def = 1;
    gain_bot_def = ((tail->gain_sign) >> GAIN_BOTDEF) & 0x01;
    sign_bot_def = ((tail->gain_sign) >> SIGN_BOTDEF) & 0x01;
    cs_bot_def = 0;
    spi.write(tail->bot_def);   // send value DAC bot def
    cs_bot_def = 1;
    gain_top_plate = ((tail->gain_sign) >> GAIN_TOPPLATE) & 0x01;
    sign_top_plate = ((tail->gain_sign) >> SIGN_TOPPLATE) & 0x01;
    cs_top_plate = 0;
    spi.write(tail->top_plate);   // send value DAC top plate
    cs_top_plate = 1;
    gain_anl = ((tail->gain_sign) >> GAIN_ANL) & 0x01;
    cs_anl = 0;
    spi.write(tail->anl);   // send value DAC top plate
    cs_anl = 1;
}

void libere_memoire()
{
    element *node,*temp;

    node = head;
    temp = node;

    while (node != NULL) {
        temp = node;
        node = node->next;
        free(temp);
    }
    head = NULL;
//    free(head);
}

