#include "mbed.h"
#include "SDFileSystem.h"
#include "wave_player.h"
#include "PinDetect.h"
#include <vector>
#include <string>

#define UP PC_13
#define DOWN PB_1
#define BACK PB_5
#define MENU PB_2
#define SELECT PB_9
#define VOLUP PB_7
#define VOLDOWN PB_6

#define LONG_PRESS_TIME 80 //Value * 20ms = debounce time
#define SHORT_PRESS_TIME 5 //Value * 20ms = debounce time

using namespace std;

SDFileSystem sd(PB_15, PB_14, PB_13, PB_12, "TEST");

PinDetect up(UP, PullUp);
PinDetect down(DOWN, PullUp);
PinDetect back(BACK, PullUp);
PinDetect menu(MENU, PullUp);
PinDetect select(SELECT, PullUp);
PinDetect volup(VOLUP, PullUp);
PinDetect voldown(VOLDOWN, PullUp);
bool buttonStatus = 0;

AnalogOut DACout(PA_4);
wave_player waver(&DACout);
int pos = 0; // index of the song
int vol = 0; // volume controller

bool playing = false; //variable for pause/play since we only have 1 pb for that
vector<string> filenames; //filenames are stored in a vector string

void read_file_names(char *dir) // function that reads in file names from sd cards
{
    DIR *dp;
    struct dirent *dirp;
    dp = opendir(dir);
    //read all directory and file names in current directory into filename vector
    while((dirp = readdir(dp)) != NULL) {
        filenames.push_back(string(dirp->d_name));
    }
}

void  upPressedCallback(void){
    //printf("\nUP Pressed\n");
    
    int l = filenames.size();
    if (pos > 0) {
        pos--;
    } else if (pos == 0 ) {
        pos = l-1;
    }
    
}
void  upHeldCallback(void){
    printf("\nUP Held\n");
}

void  downPressedCallback(void){
    //printf("\ndown Pressed\n");
    // it checks for the total number of songs in the sd card..then increments the index until it reaches the last one, then resets to 0
    
    int l = filenames.size();
    if (pos < (l-1)) {
        pos++;
    } else if (pos == (l-1)) {
        pos = 0;
    }
    
}
void  downHeldCallback(void){
    printf("\ndown Held\n");
}

void  backPressedCallback(void){
    printf("\nback Pressed\n");
}
void  backHeldCallback(void){
    printf("\nback Held\n");
}

void  menuPressedCallback(void){
    //printf("\nmenu Pressed\n");

    //this interrupt handler changes the play to pause mode or vice versa
    //this is done using the boolean playing
    
    if (playing == false) {
        playing = true; 
    } else if (playing == true) {
        playing = false; 
    }
    
}
void  menuHeldCallback(void){
    //printf("\nmenu Held\n");
}

void  volupPressedCallback(void){
    printf("\nvolup Pressed\n");
}
void  volupHeldCallback(void){
    printf("\nvolup Held\n");
}

void  voldownPressedCallback(void){
    //printf("\nvoldown Pressed\n");
    // this pb changes the volume by lowering the volume until it reaches 0. then it resets to the max volume
    // the volume range has been divided into 16 possible ranges. and hence, it toggles through those 16 values
    // this only changes the variable vol, which is then used in the wave player file to actually adjust the volume
    vol = (vol+1) % 16;
}
void  voldownHeldCallback(void){
    printf("\nvoldown Held\n");
}

bool buttons_init(void) {
    up.attach_deasserted( &upPressedCallback );
    //up.attach_deasserted( &upReleasedCallback );
    up.attach_asserted_held( &upHeldCallback );
    up.setSamplesTillAssert( SHORT_PRESS_TIME );
    up.setSamplesTillHeld( LONG_PRESS_TIME );
    up.setAssertValue( 0 );
    up.setSampleFrequency();
    //up.fall(callback(this, &upCallback));
    
    down.attach_deasserted( &downPressedCallback );
    //down.attach_deasserted( &downReleasedCallback );
    down.attach_asserted_held( &downHeldCallback );
    down.setSamplesTillAssert( SHORT_PRESS_TIME );
    down.setSamplesTillHeld( LONG_PRESS_TIME );
    down.setAssertValue( 0 );
    down.setSampleFrequency();
    
    back.attach_deasserted( &backPressedCallback );
    //back.attach_deasserted( &backReleasedCallback );
    back.attach_asserted_held( &backHeldCallback );
    back.setSamplesTillAssert( SHORT_PRESS_TIME );
    back.setSamplesTillHeld( LONG_PRESS_TIME );
    back.setAssertValue( 0 );
    back.setSampleFrequency();
    
    menu.attach_deasserted( &menuPressedCallback );
    //menu.attach_deasserted( &menuReleasedCallback );
    menu.attach_asserted_held( &menuHeldCallback );
    menu.setSamplesTillAssert( SHORT_PRESS_TIME );
    menu.setSamplesTillHeld( LONG_PRESS_TIME );
    menu.setAssertValue( 0 );
    menu.setSampleFrequency();

    volup.attach_deasserted( &volupPressedCallback );
    //volup.attach_deasserted( &volupReleasedCallback );
    volup.attach_asserted_held( &volupHeldCallback );
    volup.setSamplesTillAssert( SHORT_PRESS_TIME );
    volup.setSamplesTillHeld( LONG_PRESS_TIME );
    volup.setAssertValue( 0 );
    volup.setSampleFrequency();
    
    voldown.attach_deasserted( &voldownPressedCallback );
    //voldown.attach_deasserted( &voldownReleasedCallback );
    voldown.attach_asserted_held( &voldownHeldCallback );
    voldown.setSamplesTillAssert( SHORT_PRESS_TIME );
    voldown.setSamplesTillHeld( LONG_PRESS_TIME );
    voldown.setAssertValue( 0 );
    voldown.setSampleFrequency();
    
    /*
    down.fall(callback(&downCallback));
    back.fall(callback(&backCallback));
    menu.fall(callback(&menuCallback));
    select.fall(callback(&selectCallback));
    volup.fall(callback(&volupCallback));
    voldown.fall(callback(&voldownCallback));
    */
    
    printf("\nButtons Initialized\n");
    return 1;
}

int main()
{
    printf("\n\n\nHello, wave world =======!\n");
    buttonStatus = buttons_init();
    read_file_names("/TEST/Music");
    
    /*
    //FILE *wave_file;
    //wave_file=fopen("/TEST/queen.wav","r");
    //wave_player waver(&DACout, wave_file);
    //waver.play();
    
    wave_file=fopen("/TEST/queen.wav","r");
    waver.play();
    fclose(wave_file);
    */
    
    while(1) {
        //while pb3 is low, then we can start playing the song
        while(playing == true) { //we have 2 while loops..one while loop makes sure the music player is always on, the other one is for the song
            string songname = filenames[pos];
            string a = "/TEST/";
            string fname = a + songname; //retrieves the file name
            FILE *wave_file; 
            wave_file = fopen(fname.c_str(),"r"); //opens the music file
            waver.play(wave_file); //plays the music file
            fclose(wave_file);
        }
    }
 
}

