#include <mbed.h>
#include <mpr121.h>
#include "uLCD_4DGL.h"
#include "SDFileSystem.h"
#include "SongPlayer.h"
#include "wave_player.h"

uLCD_4DGL uLCD(p9,p10,p11);
InterruptIn interrupt(p26);
I2C i2c(p28, p27);
Mpr121 mpr121(&i2c, Mpr121::ADD_VSS);
AnalogOut DACout(p18);      // speaker
wave_player waver(&DACout); // wav player

SDFileSystem sd(p5, p6, p7, p8, "sd");

void playSound(char * wav);

int keypad(void);
int * drawfishi(int, int, int,int, int, int, int, int);

class FISHI
{
public:
    int x;
    int y;
    int ox; //oldx
    int oy; //oldy
    int r; //radius of fishi head
    int c; //fishi color
};
int i, score, big;
FISHI player;
FISHI scary1;
FISHI scary2;
FISHI scary3;
int move = 4; //player fishi move by 4
int bgC = 0xC4E6FF; //background color (water)

void playSound(char * wav)
{
    while(true) {
        FILE *wave_file;
        wave_file=fopen(wav,"r");
        if(wave_file == NULL) {
            uLCD.locate(9,0);
            uLCD.printf("ERROR_SD");
            return;
        }
        waver.play(wave_file);
        fclose(wave_file);
    }
}

int main()
{
    //player fishi default
    player.x = 64;
    player.y = 64;
    player.r = 7;
    player.c = 0xffcd8e; //orange
    player.ox = player.x;
    player.oy = player.y;

    //scary fishi default
    scary1.c = 0x000000;
    scary1.r = 7;
    scary1.x; //0 or 128
    scary2.c = 0x000000;
    scary2.r = 7;
    scary2.x; //0 or 128
    scary3.c = 0x000000;
    scary3.r = 7;
    scary3.x; //0 or 128

    int eatC = 0x8CDF59; //eatColor = green. you eat this to score
    int e1, e2, e3, e4, eat1, eat2, eat3, eat4;
    int side1, side2, side3; //starting side of scary fishi. left is 0, right is 1.
    // scary fishi moving speed
    int s = 3;
    int s2 = 6;
    int s3 = 9;
    // scary fishi y position randome generate
    int genrand1 = 1;
    int genrand2 = 1;
    int genrand3 = 1;

    int y1 = 0;
    int y2 = 0;
    int y3 = 0;

    int dir; //touchpad input
    uLCD.cls();
    int game = 0;   //game stages. 0 = welcom. 1 = play. 2 = game over
    uLCD.baudrate(500000);

    //welcome stage
    uLCD.filled_rectangle(0,0,128,128,DGREY);
    while (game == 0) {
        uLCD.locate(1,5);
        uLCD.textbackground_color(DGREY);
        //uLCD.text_string(" WELCOME TO BIG FISH GAME ", 1, 4, FONT_7X8, 0xFFFFFF);
        //
        uLCD.text_string("Press any key \n to start\n\n Use key 1,4,5,6\n\nGood Luck!", 1, 1, FONT_7X8, 0xFFFFFF);
        
        //uLCD.printf("Press any key \n to start\n\n Use key 1,4,5,6");
/*
        uLCD.locate(6,10); uLCD.printf("\n 9"); wait(1);
    uLCD.locate(6,10); uLCD.printf("\n 8"); wait(1);
    uLCD.locate(6,10); uLCD.printf("\n 7"); wait(1);
    uLCD.locate(6,10); uLCD.printf("\n 6"); wait(1);        
        uLCD.locate(6,10); uLCD.printf("\n 5"); wait(1);
    uLCD.locate(6,10); uLCD.printf("\n 4"); wait(1);
    uLCD.locate(6,10); uLCD.printf("\n 3"); wait(1);
    uLCD.locate(6,10); uLCD.printf("\n 2"); wait(1);
    uLCD.locate(6,10); uLCD.printf("\n 1"); wait(1);
        */
        
        if (keypad() != 0) {
            game = 1;
            uLCD.filled_rectangle(0,0,128,128,bgC);
        }
    }

    //game stage
    while (game == 1) {

        if (player.x-player.r-23<=e2+4-2 && player.x+player.r>=e2-4-4 && player.y-player.r<=eat2+4 && player.y+player.r>=eat2-4) {
            uLCD.filled_rectangle(e2-4-4,eat2-4,e2-2+4,eat2+4,bgC);
            e2 = 0;
           
            score++;
           // playSound("/sd/coin.wav");
        }
        if (player.x-player.r-23<=e3+4-6 && player.x+player.r>=e3-4-6 && player.y-player.r<=eat3+4 && player.y+player.r>=eat3-4) {
            uLCD.filled_rectangle(e3-6-4,eat3-4,e3-6+4,eat3+4,bgC);
            e3 = 0;
           
            score++;
           // playSound("/sd/coin.wav");
        }
        if (player.x-player.r-23<=e4+4-8 && player.x+player.r>=e4-4-8 && player.y-player.r<=eat4+4 && player.y+player.r>=eat4-4) {
            uLCD.filled_rectangle(e4-8-4,eat4-4,e4-8+4,eat4+4,bgC);
            e4 = 0;
           
            score++;
            //playSound("/sd/coin.wav");
        }

        //eat this and score!!!
        if (e1>135 || e1 == 0) {
            eat1 = rand() % (128-4) + 4;
            e1 = 0;
        }
        uLCD.filled_rectangle(e1-2-4,eat1-4,e1-2+4,eat1+4,bgC);
        uLCD.filled_circle(e1, eat1, 4, eatC);


        if (e2>135 || e2 == 0) {
            eat2 = rand() % (128-4) + 4;
            e2 = 0;
        }
        uLCD.filled_rectangle(e2-4-4,eat2-4,e2-2+4,eat2+4,bgC);
        uLCD.filled_circle(e2, eat2, 4, eatC);

        if (e3>135 || e3 == 0) {
            eat3 = rand() % (128-4) + 4;
            e3 = 0;
        }
        uLCD.filled_rectangle(e3-6-4,eat3-4,e3-6+4,eat3+4,bgC);
        uLCD.filled_circle(e3, eat3, 4, eatC);

        if (e1>135 || e1 == 0) {
            eat4 = rand() % (128-4) + 4;
            e4 = 0;
        }
        uLCD.filled_rectangle(e4-8-4,eat4-4,e4-8+4,eat4+4,bgC);
        uLCD.filled_circle(e4, eat4, 4, eatC);
      //Check Scary Fish vs My Fish Collision //
            int y_s1_p, y_s2_p, y_s3_p; 
    int x_s1_p, x_s2_p, x_s3_p;
    int y_p_s1, y_p_s2, y_p_s3;
    int x_p_s1, x_p_s2, x_p_s3;
    
    x_s1_p= abs(scary1.x - player.x);
    x_s2_p= abs(scary2.x - player.x);
    x_s3_p= abs(scary3.x - player.x);
    int x_sp_arr[] = {x_s1_p, x_s2_p, x_s3_p};
    
    y_s1_p= abs(scary1.y - player.y);
    y_s2_p= abs(scary2.y - player.y);
    y_s3_p= abs(scary3.y - player.y);
    int y_sp_arr[] = {y_s1_p, y_s2_p, y_s3_p};
    
    x_p_s1= abs( player.x - scary1.x );
    x_p_s2= abs( player.x - scary2.x );
    x_p_s3= abs( player.x - scary3.x );
    int x_ps_arr[] = {x_p_s1, x_p_s2, x_p_s3};
    
    y_p_s1= abs( player.y - scary1.y );
    y_p_s2= abs( player.y - scary2.y );
    y_p_s3= abs( player.y - scary3.y );
    int y_ps_arr[] = {y_p_s1, y_p_s2, y_p_s3};
    
    
    ///if (side1==0|| side2==0 || side3==0){
        if ((x_sp_arr[0]<32 && y_sp_arr[0] <15) || (x_sp_arr[1]<32 && y_sp_arr[1] <15 )|| (x_sp_arr[2]<32 && y_sp_arr[2] <15)|| (x_sp_arr[0]<32 && y_ps_arr[0] <15)|| (x_sp_arr[1]<32 && y_ps_arr[1] <15)|| (x_sp_arr[2]<32 && y_ps_arr[2] <15) ) {
            game=3;
        }
        if ((x_ps_arr[0]<32 && y_sp_arr[0]<15) ||( x_ps_arr[1]<32 && y_sp_arr[1] <15 )|| (x_ps_arr[2]<32 && y_sp_arr[2] <15)|| (x_ps_arr[0]<32 && y_ps_arr[0] <15)|| (x_ps_arr[1]<32 && y_ps_arr[1] <15)|| (x_ps_arr[2]<32 && y_ps_arr[2]<15)  ) {
            game=3;
       // }
        
        
    }//Comes from Left
    
    if (side1==1 || side2==1 || side3==1){
        if ( (x_sp_arr[0]<15 && y_sp_arr[0]<15) ||( x_sp_arr[1]<15 && y_sp_arr[1]<15) || (x_sp_arr[2]<15 && y_sp_arr[2]<15) || (x_sp_arr[0]<32 && y_ps_arr[0]<15) || (x_sp_arr[1]<32 && y_ps_arr[1]<10) ||( x_sp_arr[2]<32 && y_ps_arr[2] <15) ) {
            game=3;
        }
        if ( (x_ps_arr[0]<15 && y_sp_arr[0] <15) || ( x_ps_arr[1]<15 && y_sp_arr[1] <15) || (x_ps_arr[2]<15 && y_sp_arr[2]<15) || (x_ps_arr[0]<32 && y_ps_arr[0]<10 ) || ( x_ps_arr[1]<32 && y_ps_arr[1]<10) ||( x_ps_arr[2]<32 && y_ps_arr[2]<15)  ) {
            game=3;
        }
        
        
    }
     
        //USER FISHI
        dir = keyint();
        int * newfishi;
        newfishi = drawfishi(player.x,player.y,player.ox,player.oy,player.r,player.c,dir,2);
        player.x = newfishi[0];
        player.y = newfishi[1];
        player.ox = newfishi[2];
        player.oy = newfishi[3];

        //scary fishi
        if (genrand1) {
            y1 = rand() % (128-scary1.r) + scary1.r;
            genrand1 = 0;
            scary1.x = y1%2==0 ? 0 : 128;
            side1 = scary1.x==0 ? 0 : 1;
        }
        if (genrand2) {
            y2 = rand() % (128-scary2.r) + scary2.r;
            genrand2 = 0;
            scary2.x = y2%2==0 ? 0 : 128;
            side2 = scary2.x==0 ? 0 : 1;
        }
        if (genrand3) {
            y3 = rand() % (128-scary3.r) + scary3.r;
            genrand3 = 0;
            scary3.x = y3%2==0 ? 0 : 128;
            side3 = scary3.x==0 ? 0 : 1;
        }
        //scary fishi move in x by s
        scary1.x = side1==0 ? scary1.x+s : scary1.x-s;
        scary2.x = side2==0 ? scary2.x+s2 : scary2.x-s2;
        scary3.x = side3==0 ? scary3.x+s3 : scary3.x-s3;
        scary1.y = y1;
        scary2.y = y2;
        scary3.y = y3;

        newfishi = drawfishi(scary1.x,scary1.y,scary1.ox,scary1.oy,scary1.r,scary1.c,-1,side1);
        scary1.x = newfishi[0];
        scary1.y = newfishi[1];
        scary1.ox = newfishi[2];
        scary1.oy = newfishi[3];

        newfishi = drawfishi(scary2.x,scary2.y,scary2.ox,scary2.oy,scary2.r,scary2.c,-1,side2);
        scary2.x = newfishi[0];
        scary2.y = newfishi[1];
        scary2.ox = newfishi[2];
        scary2.oy = newfishi[3];

        newfishi = drawfishi(scary3.x,scary3.y,scary3.ox,scary3.oy,scary3.r,scary3.c,-1,side3);
        scary3.x = newfishi[0];
        scary3.y = newfishi[1];
        scary3.ox = newfishi[2];
        scary3.oy = newfishi[3];

        if(scary1.x<-23 || scary1.x>128+23) genrand1 = 1;
        if(scary2.x<-23 || scary2.x>128+23) genrand2 = 1;
        if(scary3.x<-23 || scary3.x>128+23) genrand3 = 1;

        if (player.x-player.r-22<=e1 && player.x+player.r>=e1-4 && player.y-player.r<=eat1+4 && player.y+player.r>=eat1-4) {
            uLCD.filled_rectangle(e1-4,eat1-4,e1+4,eat1+4,bgC);
            e1 = 0;
            score++;
        } else e1=e1+2;
        if (player.x-player.r-23<=e2+4-2 && player.x+player.r>=e2-4-4 && player.y-player.r<=eat2+4 && player.y+player.r>=eat2-4) {
            uLCD.filled_rectangle(e2-4-4,eat2-4,e2-2+4,eat2+4,bgC);
            e2 = 0;
            score++;
        } else e2=e2+4;
        if (player.x-player.r-23<=e3+4-6 && player.x+player.r>=e3-4-6 && player.y-player.r<=eat3+4 && player.y+player.r>=eat3-4) {
            uLCD.filled_rectangle(e3-6-4,eat3-4,e3-6+4,eat3+4,bgC);
            e3 = 0;
            score++;
        } else e3=e3+6;
        if (player.x-player.r-23<=e4+4-8 && player.x+player.r>=e4-4-8 && player.y-player.r<=eat4+4 && player.y+player.r>=eat4-4) {
            uLCD.filled_rectangle(e4-8-4,eat4-4,e4-8+4,eat4+4,bgC);
            e4 = 0;
            score++;
        } else e4=e4+8;

        //display score
        uLCD.locate(0,0);
        uLCD.textbackground_color(0x000000);
        uLCD.printf("%d", score );

        wait (0.05);
            // playSound("/sd/coin.wav");

        //game over when you score 10
        if (score >= 5) {
            
            game = 2;
            uLCD.filled_rectangle(0,0,128,128,0xC5EFAC);
        }
    }

    // game over
    while (game == 2) {

        if (score >= 5) {
            uLCD.textbackground_color(0xC5EFAC);
            uLCD.text_string("YOU WIN", 1, 4, FONT_7X8, BLACK);
        }
        playSound("/sd/clap.wav");

        uLCD.filled_rectangle(0,0,128,128,0xFC3D39);
        uLCD.textbackground_color(0xFC3D39);
        uLCD.text_string("YOU WON", 1, 4, FONT_7X8, BLACK);
        wait(100);
    }
    
    while (game==3) {
        
        uLCD.filled_rectangle(0,0,128,128,0xF03D39);        
        uLCD.textbackground_color(0XF00000);
        uLCD.text_string("GAME OVER", 3, 4, FONT_7X8, BLACK);
        playSound("/sd/ending.wav");
        wait(100);
        }
}

int * drawfishi(int x, int y, int ox, int oy, int r, int c, int dir, int side)
{
    int out[4];
    if (dir > 0) {
        x = dir==4 ? x-move : dir==6 ? x+move : x;
        y = dir==1 ? y-move : dir==5 ? y+move : y;
    }
    out[0] = x;
    out[1] = y;
    out[2] = ox;
    out[3] = oy;

    if (dir >0) {
        //remove old fishi
        uLCD.filled_rectangle(ox+r,oy+r,ox-23,oy-1-r,bgC);
        uLCD.filled_circle(x,y,r,c); //head
        for (i=0; i<5; i++)
            uLCD.line(x-23+i,y-3+i/2,x-23+i,y+3-i/2,c);   //tail
        for (i=0; i<17; i++)
            uLCD.line(x-19+i,y-i/2,x-19+i,y+i/2,c);   //body
        uLCD.filled_circle(x+2,y-3,1,0x000000);   //eye
        for (i=2; i<5; i++)
            uLCD.line(x-2-i,y-i,x-2-i,y+i,0xFFFFFF); //fin
        out[2] = x;
        out[3] = y;
        return out;
    }
    if (dir == -1 && side == 0) {
        uLCD.filled_rectangle(ox+r,oy+r,ox-23,oy-1-r,bgC);
        uLCD.filled_circle(x,y,r,c); //head
        for (i=0; i<5; i++)
            uLCD.line(x-23+i,y-3+i/2,x-23+i,y+3-i/2,c);   //tail
        for (i=0; i<17; i++)
            uLCD.line(x-19+i,y-i/2,x-19+i,y+i/2,c);   //body
        out[2] = x;
        out[3] = y;
        return out;
    }

    if (dir == -1 && side == 1) {
        uLCD.filled_rectangle(ox-r,oy-r-1,ox+23,oy+r,bgC);
        uLCD.filled_circle(x,y,r,c); //head
        for (i=0; i<5; i++)
            uLCD.line(x+23-i,y-3+i/2,x+23-i,y+3-i/2,c);   //tail
        for (i=0; i<17; i++)
            uLCD.line(x+19-i,y-i/2,x+19-i,y+i/2,c);   //body
        out[2] = x;
        out[3] = y;
        return out;
    }
    return out;
}

int keypad()   
{
    int value=mpr121.read(0x00); 

    switch (value) {
        case 0x40: // ->
            return 6;

        case 0x10: //<-
            return 4;

        case 0x20: // down
            return 5;

        case 0x02: // up
            return 1;
    }
    return 0;
}