#include "mbed.h"
#include <string>
string result;

//------------------------------------
// Hyperterminal configuration
// 19200 bauds, 8-bit data, no parity
//------------------------------------

Serial pc(SERIAL_TX, SERIAL_RX);
Serial sim(PA_9, PA_10);

DigitalIn mybutton(USER_BUTTON);
DigitalOut myled(LED1);
DigitalOut sim_power(D9);

void sim_callback()
{
    char x;
    x = sim.getc();
    result += x;
    pc.putc(x);
}

void sim_call(string tel)
{
    sim.printf("AT\r\n");
    result = "";
    wait(0.5);
    if(result!="\r\nOK\r\n") {
        sim_power.write(1);
        wait(3);
        sim_power.write(0);
        wait(19);
        sim.printf("ATE0\r\n");
        wait(1);
    }

    sim.printf("ATD %s;\r\n",tel);
    result = "";
    wait(1);
    if(result=="\r\nOK\r\n") {
        pc.printf("Call OK\r\n");
    } else {
        pc.printf("Call Field\r\n");
    }
}

int main()
{
    set_time(1398285720); // Set time to 04/23/2014 @ 7:13pm

    sim.attach(&sim_callback);

    pc.baud(19200);
    sim.baud(19200);

    pc.printf("\r\nTest SIM900 !\r\n");

    sim_call("*710#");

    while(1) {
        wait(1);
        //pc.printf(".");
        myled = !myled;
        if (!mybutton)
            sim_call("+213552830677");

        time_t seconds = time(NULL);
        pc.printf("%s", ctime(&seconds));


    }
}
