// Copyright 2020 Georgia Tech.  All rights reserved.
// The materials provided by the instructor in this course are for
// the use of the students currently enrolled in the course.
// Copyrighted course materials may not be further disseminated.
// This file must not be made publicly available anywhere.

#include "graphics.h"

#include "globals.h"

#define YELLOW 0xFFFF00
#define BROWN  0xD2691E
#define DIRT   BROWN

const char head[121] = {
    'G','G','G','G','G','G','G','G','G','G','G',
    'G','G','G','G','G','G','G','G','G','G','G',
    'G','R','R','R','G','G','R','R','R','G','G',
    'G','R','R','R','G','G','R','R','R','G','G',
    'G','R','R','R','G','G','R','R','R','G','G',
    'G','G','G','G','G','G','G','G','G','G','G',
    'G','R','R','R','G','G','R','R','R','G','G',
    'G','R','R','R','G','G','R','R','R','G','G',
    'G','R','R','R','G','G','R','R','R','G','G',
    'G','G','G','G','G','G','G','G','G','G','G',
    'G','G','G','G','G','G','G','G','G','G','G',
    };
 
const char tail[121] = {
    'G','G','G','G','G','G','G','G','G','G','G',
    'G','G','G','G','G','G','G','G','G','G','G',
    'G','Y','Y','Y','G','G','G','Y','Y','Y','G',
    'G','Y','Y','Y','G','G','G','Y','Y','Y','G',
    'G','Y','Y','Y','G','G','G','Y','Y','Y','G',
    'G','G','G','G','G','G','G','G','G','G','G',
    'G','G','G','G','G','G','G','G','G','G','G',
    'G','Y','Y','Y','G','G','Y','Y','Y','G','G',
    'G','Y','Y','Y','G','G','Y','Y','Y','G','G',
    'G','Y','Y','Y','G','G','Y','Y','Y','G','G',
    'G','G','G','G','G','G','G','G','G','G','G',
    }; 
    
const char poison[121] = {
    'Y','3','3','3','3','3','3','3','3','3','Y',
    '3','Y','3','3','3','3','3','3','3','Y','3',
    '3','3','Y','3','3','3','3','3','Y','3','3',
    '3','3','3','Y','3','3','3','Y','3','3','3',
    '3','3','3','3','Y','3','Y','3','3','3','3',
    '3','3','3','3','3','Y','3','3','3','3','3',
    '3','3','3','3','Y','3','Y','3','3','3','3',
    '3','3','3','Y','3','3','3','Y','3','3','3',
    '3','3','Y','3','3','3','3','3','Y','3','3',
    '3','Y','3','3','3','3','3','3','3','Y','3',
    'Y','3','3','3','3','3','3','3','3','3','Y',
    }; 
    
const char speedup[121] = {
    '3','3','3','3','3','G','3','3','3','3','3',
    '3','3','3','3','G','3','G','3','3','3','3',
    '3','3','3','G','3','3','3','G','3','3','3',
    '3','3','G','3','3','3','3','3','G','3','3',
    '3','G','3','3','3','3','3','3','3','G','3',
    'G','3','3','3','3','3','3','3','3','3','G',
    '3','3','3','3','3','G','3','3','3','3','3',
    '3','3','3','3','G','3','G','3','3','3','3',
    '3','3','3','G','3','3','3','G','3','3','3',
    '3','3','G','3','3','3','3','3','G','3','3',
    '3','G','3','3','3','3','3','3','3','G','3',
    }; 
    
const char slowdown[121] = {
    'G','3','3','3','3','3','3','3','3','3','G',
    '3','G','3','3','3','3','3','3','3','G','3',
    '3','3','G','3','3','3','3','3','G','3','3',
    '3','3','3','G','3','3','3','G','3','3','3',
    '3','3','3','3','G','3','G','3','3','3','3',
    '3','3','3','3','3','G','3','3','3','3','3',
    'G','3','3','3','3','3','3','3','3','3','G',
    '3','G','3','3','3','3','3','3','3','G','3',
    '3','3','G','3','3','3','3','3','G','3','3',
    '3','3','3','G','3','3','3','G','3','3','3',
    '3','3','3','3','G','3','G','3','3','3','3',
    }; 
    
const char decrease_length[121] = {
    '3','3','3','3','3','3','3','3','3','3','3',
    '3','3','3','3','Y','Y','3','3','3','3','3',
    '3','3','3','Y','3','3','Y','Y','Y','3','3',
    '3','3','3','Y','3','3','Y','3','3','3','3',
    '3','3','3','3','Y','Y','3','3','3','3','3',
    '3','3','3','3','3','3','3','3','3','3','3',
    '3','3','3','3','3','3','3','3','3','3','3',
    '3','3','3','3','3','3','3','3','3','3','3',
    '3','3','3','3','3','3','3','3','3','3','3',
    '3','3','3','3','3','3','3','3','3','3','3',
    '3','3','3','3','3','3','3','3','3','3','3',
    }; 
    
const char random[121] = {
    '5','5','5','5','5','G','5','5','5','5','5',
    '5','5','5','5','G','5','G','5','5','5','5',
    '5','5','5','G','5','5','5','G','5','5','5',
    '5','5','5','5','5','5','5','G','5','5','5',
    '5','5','5','5','5','5','5','G','5','5','5',
    '5','5','5','5','5','5','G','5','5','5','5',
    '5','5','5','5','5','G','5','5','5','5','5',
    '5','5','5','5','5','G','5','5','5','5','5',
    '5','5','5','5','5','G','5','5','5','5','5',
    '5','5','5','5','5','5','5','5','5','5','5',
    '5','5','5','5','5','G','5','5','5','5','5',
    }; 
    
const char moving[121] = {
    '5','5','5','5','5','D','5','5','5','5','5',
    '5','5','5','5','D','5','D','5','5','5','5',
    '5','5','5','D','5','5','5','D','5','5','5',
    '5','5','5','5','5','5','5','D','5','5','5',
    '5','5','5','5','5','5','5','D','5','5','5',
    '5','5','5','5','5','5','D','5','5','5','5',
    '5','5','5','5','5','D','5','5','5','5','5',
    '5','5','5','5','5','D','5','5','5','5','5',
    '5','5','5','5','5','D','5','5','5','5','5',
    '5','5','5','5','5','5','5','5','5','5','5',
    '5','5','5','5','5','D','5','5','5','5','5',
    }; 
    
const char invinc[121] = {
    '3','3','3','3','3','R','3','3','3','3','3',
    '3','3','3','3','3','R','3','3','3','3','3',
    '3','3','3','3','3','R','3','3','3','3','3',
    '3','3','3','3','3','R','3','3','3','3','3',
    '3','3','3','3','3','R','3','3','3','3','3',
    'R','R','R','R','R','R','R','R','R','R','R',
    '3','3','3','3','3','R','3','3','3','3','3',
    '3','3','3','3','3','R','3','3','3','3','3',
    '3','3','3','3','3','R','3','3','3','3','3',
    '3','3','3','3','3','R','3','3','3','3','3',
    '3','3','3','3','3','R','3','3','3','3','3',
    }; 
    
const char megaGoodie[121] = {
    'Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y',
    'Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y',
    'Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y',
    'Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y',
    'Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y',
    'Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y',
    'Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y',
    'Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y',
    'Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y',
    'Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y',
    'Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y',
    }; 
    
void draw_nothing(int u, int v)
{
    uLCD.filled_rectangle(u, v, u+10, v+10, BLACK);
}

void draw_img(int u, int v, const char* img)
{
    int colors[11*11];
    for (int i = 0; i < 11*11; i++)
    {
        if (img[i] == 'R') colors[i] = RED;
        else if (img[i] == 'Y') colors[i] = 0xFFFF00; // Yellow
        else if (img[i] == 'G') colors[i] = GREEN;
        else if (img[i] == 'D') colors[i] = 0xD2691E; // "Dirt"
        else if (img[i] == '5') colors[i] = LGREY; // 50% grey
        else if (img[i] == '3') colors[i] = DGREY;
        else colors[i] = BLACK;
    }
    uLCD.BLIT(u, v, 11, 11, colors);
    wait_us(250); // Recovery time!
}

void draw_wall(int u, int v)
{
    uLCD.filled_rectangle(u, v, u+10, v+10, LGREY);
}

void draw_plant(int u, int v)
{
    uLCD.filled_rectangle(u, v, u+10, v+10, GREEN);
}

void draw_goodie(int u, int v)
{
    uLCD.filled_rectangle(u, v, u+10, v+10, 0xD2691E); //DIRT
}

void draw_snake_body(int u, int v)
{
    uLCD.filled_rectangle(u, v, u+10, v+10, GREEN);
}

void draw_snake_head(int u, int v)
{
     //May need to design a snake head sprite
     //Tile still need to be designed on paper
    
    uLCD.filled_rectangle(u, v, u+10, v+10, GREEN);
    draw_img(u,v, head);
//    uLCD.filled_rectangle(u+1, v+1, u+3, v+3, RED);
//    uLCD.filled_rectangle(u+7, v+1, u+9, v+3, RED);
//    uLCD.filled_rectangle(u+1, v+7, u+3, v+9, RED);
//    uLCD.filled_rectangle(u+7, v+7, u+9, v+9, RED);
    
}

void draw_snake_tail(int u, int v)
{
     //May need to design a snake tail sprite
     //Tile still need to be designed on paper
    
    uLCD.filled_rectangle(u, v, u+10, v+10, GREEN);
    draw_img(u,v, tail); 
//    uLCD.filled_rectangle(u+1, v+1, u+3, v+3, 0xFFFF00); //YELLOW
//    uLCD.filled_rectangle(u+7, v+1, u+9, v+3, 0xFFFF00);
//    uLCD.filled_rectangle(u+1, v+7, u+3, v+9, 0xFFFF00);
//    uLCD.filled_rectangle(u+7, v+7, u+9, v+9, 0xFFFF00);
}

void draw_poison(int u, int v) {
    uLCD.filled_rectangle(u, v, u+10, v+10, BLACK);
    draw_img(u, v, poison);
}

void draw_speedup(int u, int v) {
    uLCD.filled_rectangle(u, v, u+10, v+10, BLACK);
    draw_img(u, v, speedup);
}

void draw_slowdown(int u, int v) {
    uLCD.filled_rectangle(u, v, u+10, v+10, BLACK);
    draw_img(u, v, slowdown);
}

void draw_decrease_length(int u, int v) {
    uLCD.filled_rectangle(u, v, u+10, v+10, BLACK);
    draw_img(u, v, decrease_length);
}

void draw_random(int u, int v) {
    uLCD.filled_rectangle(u, v, u+10, v+10, BLACK);
    draw_img(u, v, random);
}

void draw_moving(int u, int v) {
    uLCD.filled_rectangle(u, v, u+10, v+10, BLACK);
    draw_img(u, v, moving);
}

void draw_invinc(int u, int v) {
    uLCD.filled_rectangle(u, v, u+10, v+10, BLACK);
    draw_img(u, v, invinc);
}
void draw_megaGoodie(int u, int v) {
    uLCD.filled_rectangle(u, v, u+10, v+10, BLACK);
    draw_img(u, v, megaGoodie);
}


