
#include "Pulse.h"
#include "mbed.h"

    Pulse::Pulse(PinName pin) : output_pin(pin) {
        output_pin = 0; 
        switch_state = false;
        oscilation = 38400; //Set default oscilation to 38.4KHz
    }

    void Pulse::send_pulse(int* sequence){
        int num_switches = (sizeof(sequence)/sizeof(int));
        int tick = 1000000/oscilation;
        for(int i = 0; i < num_switches; i++){
            if(i % 2 == 0){
                change_state();
                output_pin = 1;
                flipper.attach_us(this, &Pulse::flip_pin, tick);
                wait_us(sequence[i]);
                flipper.detach();
                change_state();
                output_pin = 0;
            }else{
                wait_us(sequence[i]);
            }
        }
    }
    
    void Pulse::set_osc(int khz){
        if(khz > 0 && khz <= 250000) //Make sure that the new oscilation is positive and also less than 250KHz 
            oscilation = khz;
    }
    
    void Pulse::set_pin(PinName pin){
        output_pin = pin;
    }
            
    void Pulse::flip_pin(){
        if(switch_state) //Stop the output from switching unless it is meant to be transmitting
            output_pin = !output_pin;
        else
            output_pin = 0;
    }

    void Pulse::change_state(){
        switch_state = !switch_state;
    }



