#include "mbed.h"
#include "SDFileSystem.h"
#include "uLCD_4DGL.h"
#include "wave_player.h"
#include "Joystick.h"


Nav_Switch myNav( p9, p12, p13, p11, p10); // U, D, L, R, Fire
uLCD_4DGL uLCD(p28, p27, p29);
SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card

int arrowVec[20];


int arrow;

void mainMenu() {
    uLCD.baudrate(BAUD_3000000);
    while(1){
        uLCD.locate(3,2);
        uLCD.puts("Simon Says");
        uLCD.locate(3,6);
        uLCD.puts("Start");
        if(myNav.fire()) {
            uLCD.cls();
            return;
        }
}
}
void createArrows(int lev) {

    for (int i = 0; i < lev; i++) {
        if (arrowVec[i] == 1) {
            uLCD.cls();
            //uLCD.background_color(DGREY);
            uLCD.triangle(15, 50, 35, 45, 35, 75, RED);
            uLCD.filled_rectangle(35,50,85,70,RED);
            //wait(.2);
        } else if (arrowVec[i] == 2) {
            uLCD.cls();
            //uLCD.triangle(int x1, int y1 , int x2, int y2, int x3, int y3, RED);
            uLCD.filled_rectangle(70,35,50,85,BLUE); 
                
        } else if (arrowVec[i] == 3) {
            uLCD.cls();
            //uLCD.triangle();
            uLCD.filled_rectangle(85,70,35,50,GREEN);
        } else {
            uLCD.cls();
            uLCD.filled_rectangle(50,85,70,35,WHITE);
        }
        wait(0.2);
    }
}


int main() {
    bool game = true;
    int level = 0;
    //int arrowVec[20]; 
    //void mainMenu();
    
    
    while(game) {
        level++;
        for (int i = 0; i < level; i++) { 
            arrow = (rand() % 4) + 1;
            arrowVec[i] = arrow;
        }
        //arrowVec[0] = 1;
        createArrows(level);
        if(level==21){
            game = false;
            }    
    }
    

}
