#include "mbed.h"

PwmOut servo1(p21);
PwmOut servo2(p22);

#define waitsec 0.04
#define start 900
#define end 190

int main(){
    servo1.period_ms(20);          // servo requires a 20ms period
    servo2.period_ms(20);          // servo requires a 20ms period
    for(int i=0; i < 5; i++){
        for(int i = start; i < end; i += 10) {
            servo1.pulsewidth_us(i); // servo position determined by a pulsewidth between 1-2ms
            servo2.pulsewidth_us(i); // servo position determined by a pulsewidth between 1-2ms
            wait(waitsec);
        }
        for(int i = end; i > start; i -= 10) {
            servo1.pulsewidth_us(i); // servo position determined by a pulsewidth between 1-2ms
            servo2.pulsewidth_us(i); // servo position determined by a pulsewidth between 1-2ms
            wait(waitsec);
        }
    }
}
