#include "mbed.h"
#include "string.h"
#include "SDHCFileSystem.h"

#define PSQ 35

#define TEST_FPUTSFGETS 1
#define TEST_FWRITEFREAD 1
#define TEST_PRINTBYTEUS 0

Serial pc(USBTX, USBRX);

void speedtest(char *path, int totallen, int blocklen, bool unlinkfile){
  char *data = (char *)malloc(blocklen);
  for(int i=0; i < blocklen; i++)
    data[i] = 0x30 + (i % 10);

  int wrotelen = 0, avgus = 0, maxus = 0, blavgus = 0, blmaxus = 0;
  int maxi = 0, blmaxi = 0;
  Timer t;
  t.reset();
  t.start();
  int beginus = t.read_us();
  FILE *fp = fopen(path, "w");
  int i = 0, j = 0;
  while(wrotelen < totallen){
    int beforeus = t.read_us();
    int wl = fwrite((void *)data, 1, blocklen, fp);
    int afterus = t.read_us();
    int blockus = afterus - beforeus;
    int byteus = blockus / wl;
    avgus = (avgus ? (avgus + byteus) / 2 : byteus);
    if(maxus < byteus){
      maxus = byteus;
      maxi = i;
    }
    blavgus = (blavgus ? (blavgus + blockus) / 2 : blockus);
    if(blmaxus < blockus){
      blmaxus = blockus;
      blmaxi = i;
    }
    wrotelen += wl;
    i++;
    if(TEST_PRINTBYTEUS){
        if(byteus > 2){
            printf("%s %08d", (j++ ? "" : "\r\n"), byteus);
        }else{
            j = 0;
        }
    }
  }
  if(TEST_PRINTBYTEUS) printf("\r\n");
  fclose(fp);
  
  int endus = t.read_us();
  t.stop();

  printf("SPIFreq=%dHz TotalBytes=%d (Block)=%dbytes TotalTime=%dus\r\n",
     SDHC_SPI_FREQUENCY, wrotelen, blocklen, endus-beginus);
  printf("Time(us): max=%d(%d) avg=%d max(block)=%d(%d) avg(block)=%d\r\n",
     maxus, maxi, avgus, blmaxus, blmaxi, blavgus);
  printf("\r\n");
  
  if(unlinkfile) remove(path);
  free(data);
}


int main(){
  pc.baud(921600);
  SDFileSystem sd(p5, p6, p7, p8, "sd"); // mosi, miso, sclk, cs
  printf("%s [START %04d]\r\n", __FILE__, PSQ);
  
  char *str = "Hello, World!\n";
  int l = strlen(str) + 1;
  char *path;
  FILE *fp;
  char buf[512];
  
  if(TEST_FWRITEFREAD){
    printf("[fwrite()/fread()]\r\n");
    printf("write data of %d bytes\r\n", l);
    memset(buf, 0x00, sizeof(buf));
    path = "/sd/fwrite_fread.txt";
    
    fp = fopen(path, "w");
    int r = fwrite((void *)str, 1, l, fp);
    fclose(fp);
    printf("fwrite() not wrote whole data %d/%d\r\n", r, l);
    fp = fopen(path, "r");
    int s = fread((void *)buf, 1, r, fp);
    printf("fread() not read whole data %d/%d\r\n", s, r);
    for(int i=0; i < s; i++){
      printf("%c", buf[i]);
    }
    printf("\r\n");
    fclose(fp);
    
    printf("speed test...write\r\n");

    speedtest("/sd/fwr_5120000_0001.txt", 5120000, 1, true);
    speedtest("/sd/fwr_5120000_0002.txt", 5120000, 2, true);
    speedtest("/sd/fwr_5120000_0005.txt", 5120000, 5, true);
    speedtest("/sd/fwr_5120000_0010.txt", 5120000, 10, true);
    speedtest("/sd/fwr_5120000_0020.txt", 5120000, 20, true);
    speedtest("/sd/fwr_5120000_0050.txt", 5120000, 50, true);
    speedtest("/sd/fwr_5120000_0100.txt", 5120000, 100, true);
    speedtest("/sd/fwr_5120000_0256.txt", 5120000, 256, true);
    speedtest("/sd/fwr_5120000_0512.txt", 5120000, 512, true);
    speedtest("/sd/fwr_5120000_1024.txt", 5120000, 1024, true);
    speedtest("/sd/fwr_5120000_2048.txt", 5120000, 2048, true);
    speedtest("/sd/fwr_5120000_4096.txt", 5120000, 4096, true);
  }

  if(TEST_FPUTSFGETS){
    printf("[fputs()/fgets()]\r\n");
    memset(buf, 0x00, sizeof(buf));
    path = "/sd/fputs_fgets.txt";
    
    fp = fopen(path, "w");
    fputs(str, fp);
    fclose(fp);
    fp = fopen(path, "r");
    if(fgets(buf, sizeof(buf), fp)){
      printf("%s\r\n", buf);
    }
    fclose(fp);
  }
  
  printf("%s [END %04d]\r\n", __FILE__, PSQ);
}
