#include "mbed.h"
#include "rtos.h"

Serial pc(USBTX, USBRX);
DigitalOut myled(LED4);
Queue<uint32_t, 5> queue;


void console_out(void const *args)
{
    printf(">led thread start\r\n");
    int f = 1;
    while(f) {
        myled = 1;
        Thread::wait(500);
        myled = 0;
        Thread::wait(500);
        osEvent evt = queue.get(100);
        if(evt.status != osEventMessage) {
            printf(">returned %02x status\r\n", evt.status);
        } else {
            printf(">returned %d\r\n", evt.value.v);
            if(evt.value.v == 1) f = 0;
        }
    }
    printf(">led thread end.\r\n");
}

int main(void)
{
    pc.baud(921600);
    printf("\r\n==== mbed program start ====\r\n");
    printf("%s\r\n", __FILE__);
    Thread th_console_out(console_out);
    wait(10);
    queue.put((uint32_t*)1);
    wait(10);
    printf("=== mbed program end ====\r\n");
    exit(1);
}
