
// voice changer all function
#include "mbed.h"
#define ARRAY 4000
#define ARRAYLM1 1999
#define ARRAYHM1 999
#define ARRAYEM1 3999
#define DELAYTIME 2000
#define ECHOFACTOR 0.5

float micCB;
float x[ARRAY];
float y;
int j=0,k=0,n=0;
int mode=0;

DigitalIn sw(p5);
AnalogIn micC(p16);         
AnalogOut spOut(p18);
BusOut   leds( LED4, LED3, LED2, LED1 ); 

// voice changer (low voice)
void lowVoice(){
    while(sw) { 
        n++; if (n>1) n=0;
        if (n==0){ k++; if (k>ARRAYLM1) k=0; }
        j++; if(j>ARRAYLM1) j=0;
        x[j]=micC-micCB; 
        y=x[k];
        spOut=y*10+0.5;
        leds=abs(y*1000);
        wait_us(20);
    }
}

// voice changer (high voice)
void highVoice() {
    while(sw) { 
        n++; if (n>1) n=0;
        if (n==0){ k++; if (k>ARRAYHM1) k=0; }
        j++; if(j>ARRAYHM1) j=0;
        x[k]=micC-micCB; 
        y=x[j];
        spOut=y*10+0.5;
        leds=abs(y*1000);
        wait_us(10);
    }
}

// voice changer (ECHO)
void echoVoice() {
    k=DELAYTIME;    
    while(sw) { 
        j++; if(j>ARRAYEM1) j=0;
        k++; if (k>ARRAYEM1) k=0;
        y=x[j]+=micC-micCB;      
        x[k]=x[j]*ECHOFACTOR;       
        
        spOut=y*10+0.5;
        leds=abs(y*1000);
        wait_us(50);
    }
}

//------------------main-----------------------
int main() {
    wait(2);
    micCB=0;
    for(int i=0;i<1000;i++){ micCB+=micC; } 
    micCB/=1000;   
    
    while(1){
        switch(mode){
            case 0: lowVoice(); break;
            case 1: highVoice(); break;
            case 2: echoVoice(); break;
        }
        while(sw==0);
        wait(0.5);
        mode++; if (mode>2) mode=0;
    }
}