/*
// normal voice
#include "mbed.h"
float micCB;
float y;

AnalogIn micC(p16);         
AnalogOut spOut(p18);
BusOut   leds( LED4, LED3, LED2, LED1 ); 

int main() {
    wait(2);
    
    micCB=0;
    for(int i=0;i<1000;i++){
        micCB+=micC;
    }
    micCB/=1000;   
    
    while(1) { 
        y=micC-micCB; 
        spOut=y*10+0.5;
        leds=abs(y*1000);
        wait_us(20);
    }
}





// y wo 2 kai syuuki de 0
#include "mbed.h"
float micCB;
float y;
int j;

AnalogIn micC(p16);         
AnalogOut spOut(p18);
BusOut   leds( LED4, LED3, LED2, LED1 ); 

int main() {
    wait(2);
    
    micCB=0;
    for(int i=0;i<1000;i++){
        micCB+=micC;
    }
    micCB/=1000;   
    
    while(1) { 
        j++; if(j>1) j=0;
        if(j==0) y=micC-micCB;  else y=0;
        if (abs(y)>0.005) spOut=y*10+0.5;
        leds=abs(y*1000);
        wait_us(20);
    }
}




// idouheikin 
#include "mbed.h"
float micCB;
float x1,x2,x3,x4;
float y;
int j;

AnalogIn micC(p16);         
AnalogOut spOut(p18);
BusOut   leds( LED4, LED3, LED2, LED1 ); 
  
int main() {
    wait(2);
    
    micCB=0;
    for(int i=0;i<1000;i++){
        micCB+=micC;
    }
    micCB/=1000;   
    
    while(1) { 
        y=x2+x1;
        x2=x1;
        x1=micC-micCB; 
        spOut=y*10+0.5;
        leds=abs(y*1000);
        wait_us(10);
    }
}




// smoothing voice
#include "mbed.h"
float micCB;
float x1,x2,x3,x4;
float y;
int j;

AnalogIn micC(p16);         
AnalogOut spOut(p18);
BusOut   leds( LED4, LED3, LED2, LED1 ); 

float smooth(float a, float b, float factor){
    return(a*factor+b*(1-factor));
}
    
int main() {
    wait(2);
    
    micCB=0;
    for(int i=0;i<1000;i++){
        micCB+=micC;
    }
    micCB/=1000;   
    
    while(1) { 
        //y=x2+x1;
        //x2=x1;
        y=smooth(micC-micCB,y,0.05); 
        spOut=y*10+0.5;
        leds=abs(y*1000);
        wait_us(10);
    }
}




// voice changer (low voice)
#include "mbed.h"
#define ARRAY 2000
#define ARRAYM1 1999

float micCB;
float x[ARRAY];
float y;
int j=0,k=0,n=0;
AnalogIn micC(p16);         
AnalogOut spOut(p18);
BusOut   leds( LED4, LED3, LED2, LED1 ); 

int main() {
    wait(2);
    micCB=0;
    for(int i=0;i<1000;i++){ micCB+=micC; } 
    micCB/=1000;   
    
    while(1) { 
        n++; if (n>1) n=0;
        if (n==0){ k++; if (k>ARRAYM1) k=0; }
        j++; if(j>ARRAYM1) j=0;
        x[j]=micC-micCB; 
        y=x[k];
        spOut=y*10+0.5;
        leds=abs(y*1000);
        wait_us(20);
    }
}


// voice changer (high voice)
#include "mbed.h"
#define ARRAY 1000
#define ARRAYM1 999

float micCB;
float x[ARRAY];
float y;
int j=0,k=0,n=0;
AnalogIn micC(p16);         
AnalogOut spOut(p18);
BusOut   leds( LED4, LED3, LED2, LED1 ); 

int main() {
    wait(2);
    micCB=0;
    for(int i=0;i<1000;i++){ micCB+=micC; } 
    micCB/=1000;   
    
    while(1) { 
        n++; if (n>1) n=0;
        if (n==0){ k++; if (k>ARRAYM1) k=0; }
        j++; if(j>ARRAYM1) j=0;
        x[k]=micC-micCB; 
        y=x[j];
        spOut=y*10+0.5;
        leds=abs(y*1000);
        wait_us(10);
    }
}




// voice changer (ECHO)
#include "mbed.h"
#define ARRAY 4000
#define ARRAYM1 3999
#define DELAYTIME 2000
#define ECHOFACTOR 0.6

float micCB;
float x[ARRAY];
float y;
int j=0,k=0,n=0;
AnalogIn micC(p16);         
AnalogOut spOut(p18);
BusOut   leds( LED4, LED3, LED2, LED1 ); 

int main() {
    wait(2);
    micCB=0;
    for(int i=0;i<1000;i++){ micCB+=micC; } 
    micCB/=1000;   
    
    k=DELAYTIME;    
    while(1) { 
        j++; if(j>ARRAYM1) j=0;
        k++; if (k>ARRAYM1) k=0;
        y=x[j]+=micC-micCB;      
        x[k]=x[j]*ECHOFACTOR;       
        
        spOut=y*10+0.5;
        leds=abs(y*1000);
        wait_us(50);
    }
}

*/