#include "mbed.h"
#define NUMDAT 15000
#define DLY 250
float micCB;
char st[10];
short dat[NUMDAT];
int i;
int k=0;

LocalFileSystem local("local");    
DigitalIn sw(p5);   
AnalogIn micC(p16);     
AnalogOut spOut(p18);
BusOut   leds( LED4, LED3, LED2, LED1 ); 
Ticker timer; 

void offset(){
    micCB=0;
    for(i=0;i<100;i++) micCB+=micC; 
    micCB/=100;
}

void fout(){
    FILE *fp = fopen("/local/out.txt", "w");  
    for(i=0;i<NUMDAT; i++){
        fprintf(fp,"%d\n",dat[i]);
    }
    fclose(fp);
}

void fin(){
    FILE *fp = fopen("/local/out.txt", "r");  
    for(i=0;i<NUMDAT; i++){
        fgets(st,10,fp);
        dat[i]=atoi(st);
    }
    fclose(fp);
}

void record(){
    for(i=0;i<NUMDAT; i++){
        dat[i]=(int)((micC-micCB)*32768);
        wait_us(DLY);
    }
}
    
void speak(){
    for(i=0;i<NUMDAT; i++){
        spOut=((float)dat[i])/32768*10+0.5; 
        wait_us(DLY);
    }
}
    

int main() {
    fin();
    speak();
    
    leds=0;
    offset();

    while(1){
        while(sw);
        wait(2);    
        leds=1;
        record();
        leds=0;    
        wait(1);
        speak();
        fout();
    }
}




