#include "mbed.h"
#define NUMDAT 15000
#define DLY 250

float micCB;
short dat[NUMDAT];
int i;
 
DigitalIn sw(p5); 
AnalogIn micC(p16);     
AnalogOut spOut(p18);
BusOut   leds( LED4, LED3, LED2, LED1 );  

void voiceOut(){
    leds=2;
    for(i=0;i<NUMDAT; i++){
        spOut=((float)dat[i])/32768*10+0.5; 
        wait_us(DLY);
    }
}

int main() {
    leds=0;
    wait(1);
    micCB=0;
    for(i=0;i<100;i++){ micCB+=micC; } 
    micCB/=100;
    leds=1;
    
    // record voice
    for(i=0;i<NUMDAT; i++){
        dat[i]=(int)((micC-micCB)*32768);
        wait_us(DLY);
    }
   
    while(1){
        leds=0;
        if (sw==0) voiceOut();
    }
}



