#define NUMDAT 15000
#define DLY 250

#include <string.h>
#include "mbed.h"
#include "voicedata.h"

float micCB;
//char st[10];
volatile short dat[NUMDAT];
volatile int num;
volatile int bufsize=0;
volatile int bufDly=0;
volatile int m=0;   // buffer index
volatile int n=0;

Serial pc(USBTX, USBRX); // tx, rx
AnalogOut spOut(p18);
BusOut   leds( LED4, LED3, LED2, LED1 ); 
Ticker timer; 


short readBuffer(){
    short tmp; 
    tmp=dat[m];
    m++; if (m>(NUMDAT-1)) m=0;
    bufsize--;
    return(tmp);
}
    
void writeBuffer(int tmp){
    while(bufsize>(NUMDAT-2)); 
    dat[n]=(short)tmp;
    n++; if (n>(NUMDAT-1)) n=0;
    if (bufsize==0) bufDly=5000;
    bufsize++;
}


void recvStr(char *buf){
    int i = 0;
    char c;
    leds=1;
    while (1) {
        if (pc.readable()) {
            c = pc.getc();
            pc.putc(c);
            buf[i] = c;
            if (c == 13) break;
            i++;
        }
    }
    buf[i] = '\0';
    pc.putc('\n');
} 


void setVoice(int code){
    int i;
    switch(code){
        case  0: for(i=1;i<=B[0]; i++) writeBuffer(B[i]); break;
        case  1: for(i=1;i<=a[0]; i++) writeBuffer(a[i]); break;
        case  2: for(i=1;i<=ii[0]; i++) writeBuffer(ii[i]); break;
        case  3: for(i=1;i<=u[0]; i++) writeBuffer(u[i]); break;
        case  4: for(i=1;i<=e[0]; i++) writeBuffer(e[i]); break;
        case  5: for(i=1;i<=o[0]; i++) writeBuffer(o[i]); break;
        case  6: for(i=1;i<=ka[0]; i++) writeBuffer(ka[i]); break;
        case  7: for(i=1;i<=ki[0]; i++) writeBuffer(ki[i]); break;
        case  8: for(i=1;i<=ku[0]; i++) writeBuffer(ku[i]); break;
        case  9: for(i=1;i<=ke[0]; i++) writeBuffer(ke[i]); break;
        case 10: for(i=1;i<=ko[0]; i++) writeBuffer(ko[i]); break;
        case 11: for(i=1;i<=sa[0]; i++) writeBuffer(sa[i]); break;
        case 12: for(i=1;i<=si[0]; i++) writeBuffer(si[i]); break;
        case 13: for(i=1;i<=su[0]; i++) writeBuffer(su[i]); break;
        case 14: for(i=1;i<=se[0]; i++) writeBuffer(se[i]); break;
        case 15: for(i=1;i<=so[0]; i++) writeBuffer(so[i]); break;
        case 16: for(i=1;i<=ta[0]; i++) writeBuffer(ta[i]); break;
        case 17: for(i=1;i<=ti[0]; i++) writeBuffer(ti[i]); break;
        case 18: for(i=1;i<=tu[0]; i++) writeBuffer(tu[i]); break;
        case 19: for(i=1;i<=te[0]; i++) writeBuffer(te[i]); break;
        case 20: for(i=1;i<=to[0]; i++) writeBuffer(to[i]); break;
        case 21: for(i=1;i<=na[0]; i++) writeBuffer(na[i]); break;
        case 22: for(i=1;i<=ni[0]; i++) writeBuffer(ni[i]); break;
        case 23: for(i=1;i<=nu[0]; i++) writeBuffer(nu[i]); break;
        case 24: for(i=1;i<=ne[0]; i++) writeBuffer(ne[i]); break;
        case 25: for(i=1;i<=no[0]; i++) writeBuffer(no[i]); break;
        case 26: for(i=1;i<=ha[0]; i++) writeBuffer(ha[i]); break;
        case 27: for(i=1;i<=hi[0]; i++) writeBuffer(hi[i]); break;
        case 28: for(i=1;i<=hu[0]; i++) writeBuffer(hu[i]); break;
        case 29: for(i=1;i<=he[0]; i++) writeBuffer(he[i]); break;
        case 30: for(i=1;i<=ho[0]; i++) writeBuffer(ho[i]); break;
        case 31: for(i=1;i<=ma[0]; i++) writeBuffer(ma[i]); break;
        case 32: for(i=1;i<=mi[0]; i++) writeBuffer(mi[i]); break;
        case 33: for(i=1;i<=mu[0]; i++) writeBuffer(mu[i]); break;
        case 34: for(i=1;i<=me[0]; i++) writeBuffer(me[i]); break;
        case 35: for(i=1;i<=mo[0]; i++) writeBuffer(mo[i]); break;
        case 36: for(i=1;i<=ya[0]; i++) writeBuffer(ya[i]); break;
        case 37: for(i=1;i<=yu[0]; i++) writeBuffer(yu[i]); break;
        case 38: for(i=1;i<=yo[0]; i++) writeBuffer(yo[i]); break;
        case 39: for(i=1;i<=ra[0]; i++) writeBuffer(ra[i]); break;
        case 40: for(i=1;i<=ri[0]; i++) writeBuffer(ri[i]); break;
        case 41: for(i=1;i<=ru[0]; i++) writeBuffer(ru[i]); break;
        case 42: for(i=1;i<=re[0]; i++) writeBuffer(re[i]); break;
        case 43: for(i=1;i<=ro[0]; i++) writeBuffer(ro[i]); break;
        case 44: for(i=1;i<=wa[0]; i++) writeBuffer(wa[i]); break;
        case 45: for(i=1;i<=wo[0]; i++) writeBuffer(wo[i]); break;
        case 46: for(i=1;i<=nn[0]; i++) writeBuffer(nn[i]); break;
        case 47: for(i=1;i<=ga[0]; i++) writeBuffer(ga[i]); break;
        case 48: for(i=1;i<=gi[0]; i++) writeBuffer(gi[i]); break;
        case 49: for(i=1;i<=gu[0]; i++) writeBuffer(gu[i]); break;
        case 50: for(i=1;i<=ge[0]; i++) writeBuffer(ge[i]); break;
        case 51: for(i=1;i<=go[0]; i++) writeBuffer(go[i]); break;
        case 52: for(i=1;i<=za[0]; i++) writeBuffer(za[i]); break;
        case 53: for(i=1;i<=zi[0]; i++) writeBuffer(zi[i]); break;
        case 54: for(i=1;i<=zu[0]; i++) writeBuffer(zu[i]); break;
        case 55: for(i=1;i<=ze[0]; i++) writeBuffer(ze[i]); break;
        case 56: for(i=1;i<=zo[0]; i++) writeBuffer(zo[i]); break;
        case 57: for(i=1;i<=da[0]; i++) writeBuffer(da[i]); break;
        case 58: for(i=1;i<=di[0]; i++) writeBuffer(di[i]); break;
        case 59: for(i=1;i<=du[0]; i++) writeBuffer(du[i]); break;
        case 60: for(i=1;i<=de[0]; i++) writeBuffer(de[i]); break;
        case 61: for(i=1;i<=dho[0]; i++) writeBuffer(dho[i]); break;
        case 62: for(i=1;i<=ba[0]; i++) writeBuffer(ba[i]); break;
        case 63: for(i=1;i<=bi[0]; i++) writeBuffer(bi[i]); break;
        case 64: for(i=1;i<=bu[0]; i++) writeBuffer(bu[i]); break;
        case 65: for(i=1;i<=be[0]; i++) writeBuffer(be[i]); break;
        case 66: for(i=1;i<=bo[0]; i++) writeBuffer(bo[i]); break;
        case 67: for(i=1;i<=pa[0]; i++) writeBuffer(pa[i]); break;
        case 68: for(i=1;i<=pi[0]; i++) writeBuffer(pi[i]); break;
        case 69: for(i=1;i<=pu[0]; i++) writeBuffer(pu[i]); break;
        case 70: for(i=1;i<=pe[0]; i++) writeBuffer(pe[i]); break;
        case 71: for(i=1;i<=po[0]; i++) writeBuffer(po[i]); break;
        case 72: for(i=1;i<=kya[0]; i++) writeBuffer(kya[i]); break;
        case 73: for(i=1;i<=kyu[0]; i++) writeBuffer(kyu[i]); break;
        case 74: for(i=1;i<=kyo[0]; i++) writeBuffer(kyo[i]); break;
        case 75: for(i=1;i<=sya[0]; i++) writeBuffer(sya[i]); break;
        case 76: for(i=1;i<=syu[0]; i++) writeBuffer(syu[i]); break;
        case 77: for(i=1;i<=syo[0]; i++) writeBuffer(syo[i]); break;
        case 78: for(i=1;i<=tya[0]; i++) writeBuffer(tya[i]); break;
        case 79: for(i=1;i<=tyu[0]; i++) writeBuffer(tyu[i]); break;
        case 80: for(i=1;i<=tyo[0]; i++) writeBuffer(tyo[i]); break;
        case 81: for(i=1;i<=nya[0]; i++) writeBuffer(nya[i]); break;
        case 82: for(i=1;i<=nyu[0]; i++) writeBuffer(nyu[i]); break;
        case 83: for(i=1;i<=nyo[0]; i++) writeBuffer(nyo[i]); break;
        case 84: for(i=1;i<=hya[0]; i++) writeBuffer(hya[i]); break;
        case 85: for(i=1;i<=hyu[0]; i++) writeBuffer(hyu[i]); break;
        case 86: for(i=1;i<=hyo[0]; i++) writeBuffer(hyo[i]); break;
        case 87: for(i=1;i<=mya[0]; i++) writeBuffer(mya[i]); break;
        case 88: for(i=1;i<=myu[0]; i++) writeBuffer(myu[i]); break;
        case 89: for(i=1;i<=myo[0]; i++) writeBuffer(myo[i]); break;
        case 90: for(i=1;i<=gya[0]; i++) writeBuffer(gya[i]); break;                
        case 91: for(i=1;i<=gyu[0]; i++) writeBuffer(gyu[i]); break;
        case 92: for(i=1;i<=gyo[0]; i++) writeBuffer(gyo[i]); break;
        case 93: for(i=1;i<=jya[0]; i++) writeBuffer(jya[i]); break;
        case 94: for(i=1;i<=jyu[0]; i++) writeBuffer(jyu[i]); break;
        case 95: for(i=1;i<=jyo[0]; i++) writeBuffer(jyo[i]); break;
        case 96: for(i=1;i<=bya[0]; i++) writeBuffer(bya[i]); break;
        case 97: for(i=1;i<=byu[0]; i++) writeBuffer(byu[i]); break;
        case 98: for(i=1;i<=byo[0]; i++) writeBuffer(byo[i]); break;
        case 99: for(i=1;i<=pya[0]; i++) writeBuffer(pya[i]); break;
        case 100: for(i=1;i<=pyu[0]; i++) writeBuffer(pyu[i]); break;                
        case 101: for(i=1;i<=pyo[0]; i++) writeBuffer(pyo[i]); break;
    }
}

void errVoice(){
    setVoice(0);
    setVoice(4);
    setVoice(39);
    //setVoice(1);
}

void speech(){
    short tmp;
    if (bufDly>0){
        bufDly--;
        return;
    }
    if (bufsize>0){
        tmp=readBuffer();
        spOut=(float)tmp/32768*10+0.5; 
    }
}

int main() {
    int i,k,len;
    timer.attach_us(speech,250); 
    
/*    
    // test voice output 
    for (i=1;i<102;i++) setVoice(i);
*/

    while(1){
        char str[20]; 
        recvStr(str);
        len=strlen(str);
        while(strlen(str)!=0){
            for(i=0;i<102;i++){
                if (strstr(str,voice[i])==str){
                    k=strlen(voice[i]);
                    setVoice(i);
                    strcpy(str, &str[k]);
                    break;
                } 
            }
            if (i==102){ 
                errVoice();
                break; 
            }
        }
    }
}





