#include "mbed.h"
#include "ReceiverIR.h"

DigitalOut  my_led(LED1);

PwmOut      my_pwm1(PB_3);
PwmOut      my_pwm2(PB_5);


ReceiverIR ir_rx(D2);

Serial pc(SERIAL_TX, SERIAL_RX);
DigitalOut myled(LED1);

RemoteIR::Format format;
uint8_t buf[32];
int bitcount, decoded;
double DC=0.5;

int main()
{
    my_pwm1.period_us(200);
    my_pwm1.write(DC);
    
    my_pwm2.period_us(200);
    my_pwm2.write(DC);
       

    pc.printf("Hello World !\r\n");
    while(1) {
        
        if (ir_rx.getState() == ReceiverIR::Received) {
            bitcount = ir_rx.getData(&format, buf, sizeof(buf) * 8);
            myled=1;
            if (bitcount>0) {
                decoded=buf[3];
                pc.printf("\r\nDecoded: %02X ", buf[3]);
            }
                
                pc.printf(".");
                myled = !myled;
                    
                if (decoded==0xE5){
                    DC = DC+ 0.01;
                    if (DC>1) DC=1;
                }
                if (decoded==0xD4){
                    DC = DC- 0.01;
                    if (DC<0) DC=0;
                }    
                if (decoded==0xC3){
                    DC = 0.5;
                }   
                    
                    my_pwm1.write(DC);
                    my_pwm2.write(DC);
                
                
                /* DEBUG
                    for (int i = 0; i < bitcount; i++) {
                     pc.printf("%02X", buf[i]);
                    }
                */
            
        } else myled=0;
        
    }
}
