#include <stdio.h>
#include <math.h>

enum eckig { ja, nein };

class Form          // Basisklasse 
{                   
                    // In der Basisklasse werden alle gemeinsamen Variablen
  protected:          
    eckig m_hat_ecken;
    float m_umfang;
    float m_flaeche;
 
  public:                   // sowie auch alle gemeinsamen Methoden deklariert
    float leseUmfang() { return m_umfang; }
    float leseFlaeche() { return m_flaeche; }

    Form(eckig hat_ecken);
};

Form::Form(eckig ecken) {   // im Konstruktor werden gem. Variablen initialisiert
    m_hat_ecken = ecken;
    m_umfang = 0;
    m_flaeche = 0;
};

class Kreis : public Form // erstellen einer neuen Klasse mit Verweis auf die Basisklasse
{ 
    
  protected:                
    float m_radius; // eigentlich überflüssig, da nie verwendet
    
  public:    // nicht benötigt, da in Form schon ausprogrammiert
    float leseUmfang() { return m_umfang; } 
    float leseFlaeche() { return m_flaeche; }
    
    Kreis(float radius);    
};

Kreis::Kreis(float radius) : Form(nein) 
{
    m_umfang = 2 * radius * M_PI; 
    m_flaeche = radius * radius * M_PI;
};


class Rechteck : public Form // erstellen einer neuen Klasse mit Verweis auf die Basisklasse
{
    protected:
     float m_seiteA; // eigentlich überflüssig, da nie verwendet
     float m_seiteB; // eigentlich überflüssig, da nie verwendet

   public:    
     float leseUmfang() { return m_umfang; } 
     float leseFlaeche() { return m_flaeche; }
    
    Rechteck(float m_seiteA); // Deklaration des Konstruktors
    Rechteck(float m_seiteA, float m_seiteB);
};

// :: gibt die Klassenzugehörigkeit an
Rechteck::Rechteck(float m_seiteA) : Form(ja){}; // Definition des Konstruktors
Rechteck::Rechteck(float m_seiteA, float m_seiteB) : Form(ja)
{
   m_umfang = 2*m_seiteA + 2*m_seiteB; // Berechnungen
   m_flaeche = m_seiteA * m_seiteB; 
};

class Quadrat : public Rechteck // erstellen einer neuen Unterklasse mit Verweis auf die vorherige
{
   public:    
    float leseUmfang() { return m_umfang; } 
    float leseFlaeche() { return m_flaeche; }
    
    Quadrat(float m_seiteA); // Deklaration des Konstruktors
};

// :: gibt die Klassenzugehörigkeit an
Quadrat::Quadrat(float m_seiteA) : Rechteck (m_seiteA) // Definition des Konstruktors
{
    m_umfang = 4*m_seiteA; // Berechnungen
    m_flaeche = m_seiteA*m_seiteA;
};

int main()
{
    Kreis kr(1.0);
    
    printf("Der Umfang des Kreis beträgt: %f m.\n", kr.leseUmfang());
    printf("Der Fläche des Kreis beträgt: %f m².\n\n", kr.leseFlaeche());
    
    Rechteck rk(2.3,2.6);
    
    printf("Der Umfang des Rechtecks beträgt: %f m.\n", rk.leseUmfang());
    printf("Die Fläche des Rechtecks beträgt: %f m².\n\n", rk.leseFlaeche());
    
    Quadrat qu(3.0);
 
    printf("Der Umfang des Quadrats beträgt: %f m.\n", qu.leseUmfang());
    printf("Der Fläche des Quadrats beträgt: %f m².\n\n", qu.leseFlaeche());
    return 0;
}
