#include "mbed.h"

// DigitalOut eine Variable für ein Bit
// BusOut eine Variable für eine ganze Bitgruppe
// Alle 12-Leds des M0-Boards zu einer Bitgruppe zusammenfassen
//        LSB                                                      MSB
//        2^0   2^1   2^2                                          2^11
BusOut lb(P1_13,P1_12,P1_7,P1_6,P1_4,P1_3,P1_1,P1_0,LED4,LED3,LED2,LED1);
//        D20   D19   D18  D17  D16  D15  D14  D13  D4   D3   D2   D1

//         SW 1   SW 2   SW 3   SW 4
//         Bit0   Bit1   Bit2   Bit3
BusIn btn(P0_10, P0_15, P0_23, P0_16);

void OneRunLightStep();
void OneRunLightStep2(); //Einen Schritt des Runlight's ausführen

int prevSw3 = 0; //Schalterzustand so wie er bei der letzten Abfrage war

//CheckButton() liefert nur dann 1 wenn eine Flanke am Button erkannt wurde
int CheckButton()
{
    int ret = 0;
    if( prevSw3==0 && (btn&4))
     ret = 1;  
    
    else
     ret = 0;
     prevSw3 = (btn & 4); //alten Zustand merken
     return ret;
}

int main()
{
  lb = 1;
  while(1)  
  {
    
    if (CheckButton())
    {
        OneRunLightStep();
    }
  } 
}

int gCnt = 0;
void OneRunLightStep()
{
  lb = lb << 1; 
  gCnt++;
  if(gCnt > 11)
  {
      lb = 1;
      gCnt = 0;
  } 
}
void OneRunLightStep2()
{
  if(lb == 0)
  {
      lb = 1;
  }
  else
  {
      lb = lb << 1;
  }
}

