#include "mbed.h"
#define btn1 p14     // push joystick pin
#define btn2 p12    //  joystick down
 
BusOut leds(LED1,LED2,LED3,LED4);

Timer t1; 
Ticker tick1, tick2;
Timeout tout;
InterruptIn btn_push(btn1);
InterruptIn btn_down(btn2);
 
void blink_led1() 
{
    leds = leds^0b0001;        
}
 
void shiftled() 
{       
    leds = leds << 1;
    leds = leds | 0b0010; 
    if ( leds == 0b1111)
    {
        leds = leds ^ 0b1111;
    }
}
 
void turn_led2_on() 
{
    leds = 0b0010;
}

void ledsoff()
{
    leds = 0b0000;
}
 
int main() 
{
    //t1.start();
    
    tick1.attach(callback(&blink_led1), 1.0f);
    tick2.attach(callback(&ledsoff), 10.0f);
    
    btn_push.rise(callback(&turn_led2_on));
    btn_down.rise(callback(&shiftled));
    //btn.fall(callback(&toggle_led2));
 
}
