#include "Functions.h"


DigitalIn shockButton(p16);
DigitalIn chargeButton(p17);
DigitalIn byPassButton(p32);

//sync IN, ECG R wave In pin
InterruptIn SyncIn(p14);
//InterruptIn byPassButton(p15);

//shock signal to defeb
DigitalOut shock(p26);
//charge signal to defeb
DigitalOut charge(p25);

//charge signal from defeb
DigitalIn chargeLEDCheck(p30);

// Relay to power Amplifier 
DigitalOut HFAC_Relay(p5);
//Middle Relay off
DigitalOut M_Relay_B(p6);
//Middle Relay On
DigitalOut M_Relay(p7);
// Resistor Relay : No need any more
DigitalOut R_Relay(p8);

//Sync out to dfeb to deliver the shock 
DigitalOut SyncOut(p20);

//HFAC  Analog out put
AnalogOut HFAC(p18);

//Test leds
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

//Shock button Leds
DigitalOut shockRedLED(p34);
DigitalOut shockGreenLED(p33);

//Charge button Leds
DigitalOut chargeRedLED(p39);
DigitalOut chargeGreenLED(p38);

// serial link for LCD
Serial LCD(p9, p10);

// serial link for PC
Serial pc(USBTX, USBRX);

uint16_t sample = 0;

char temp;
int HFAC_Duration = 1300;
int HFAC_Amplitude = 100;
int LCD_Counter = 0;
int LCD_Message = 0;
int LCD_Source = 0;

bool byPassOldStatus = false;
bool byPassStatus = false;

//Timer for calculating the time bewteen each R wave signal
Timer heartRateTimer;
//TimeOut Timer for deleviring shock after detecting "HeartRateAvg + 1" R wave signal
Timeout deliverTimeout;

bool heartRateTimerStart = false;
int heartRate = 0;
int heartMeanCounter = 0;
int heartRateTemp = 0;

bool syncActivate = false;
bool syncShock = false;

bool DfebCharged = false;

int main()
{

    ////////init//////////////
    LCD.baud(115200);
    shockButton.mode(PullUp);
    chargeButton.mode(PullUp);
    byPassButton.mode(PullUp);
    chargeLEDCheck.mode(PullDown);
    
    SyncIn.mode(PullDown);
    
 //   byPassButton.rise(&checkByPass);
 //   byPassButton.fall(&checkByPass);
    
    M_Relay = 1;
    wait_ms(1);
    M_Relay = 0;
    HFAC_Relay = 0;
    R_Relay = 0;
    // Make the HFAC analog to VDD/2
    HFAC.write_u16(offset);

    led1 = 1;
    SyncOut =0;
    wait_ms(200);
    
    checkByPass();
    
    SyncIn.rise(&syncInFunc);
    SyncIn.fall(&syncInFuncFall);

    
    while(1) {
        //Check if the bypass  status has changed 
        if (byPassOldStatus != byPassButton){
            wait_ms(200);
            checkByPass();
        } 
        
        byPassOldStatus = byPassButton;
        
        //Check Charge button status 
        if (!chargeButton){
            charge =1; 
            led3 = 1;
            led4 = 0; 
        
            //R_Relay = 1;
            
            //M_Relay_B = 1;
            //wait_ms(1);
            //M_Relay_B = 0;
            
            //HFAC_Relay = 1;
            wait_ms(100);
            charge=0;         
        }
        if (chargeLEDCheck){
            DfebCharged = true;
        }
        //Check Shock button status 
        if (!shockButton) {
            //pc.printf("shock");
            wait_ms(50);
            if (!shockButton){
                led4 = 1;
                led3 = 0;
                shock = 1;
                wait_ms(300);
                            
                M_Relay_B = 1;
                wait_ms(1);
                M_Relay_B = 0;
                
                HFAC_Relay = 1;
                if (syncActivate){
                    heartRateTimer.stop();
                    heartRateTimer.reset(); 
                    heartRateTimerStart = false;
                    heartRate = 0;
                    heartMeanCounter = 0;
                    heartRateTemp = 0; 
                    syncShock = true;
                }
                else{
                    if (byPassStatus)
                        Delivering (HFAC_Amplitude, HFAC_Duration);
                    else
                        Delivering (10, 100);
             
                    wait_ms(1000);
                }
            }
        }
        //Check if there is a message from LCD
        // The LCD message is in format of: 'A' + 2 bytes  or 'B' + 2 bytes 
        // 'C' and 'D' for Activiate or Deactivate the sync mode ( Shock on R wave)
        if(LCD.readable()) {
               
            temp = LCD.getc();
            led2 = !led2;
            if (temp == 0x43)
                syncActivate = true;
            else if (temp == 0x44)
                syncActivate = false;
            
                
            if ((temp == 0x41 || temp == 0x42)&& !LCD_Counter){
                LCD_Source =  temp;
                LCD_Counter ++;
            }
            else if (LCD_Counter == 1){
                LCD_Counter ++;
                LCD_Message = temp;
            }
            else if (LCD_Counter == 2){
                LCD_Counter ++;
                LCD_Message = LCD_Message + (temp << 8);
                LCD_Counter = 0;
                if (LCD_Source == 0x41){
                    HFAC_Duration = LCD_Message; 
                    pc.printf("HF %d\n", HFAC_Duration);
                }
                else if (LCD_Source == 0x42){
                    HFAC_Amplitude = LCD_Message ;
                    pc.printf("AM %d\n", HFAC_Amplitude);
                }
            }
            
        }
    }

}
