#ifndef DFEB_Functions
#define DFEB_Functions
#include "mbed.h"

#define HeartRateAvg  3

#define shockButtonRedLED  0
#define shockButtonGreenLED  1
#define chargeButtonRedLED  2
#define chargeButtonGreenLED  3
#define Enable 1
#define Disable 0



extern DigitalIn shockButton;
extern DigitalIn chargeButton;
//extern InterruptIn byPassButton;
extern DigitalIn byPassButton;


extern DigitalOut shock;


extern DigitalOut HFAC_Relay;
extern DigitalOut M_Relay_B;
extern DigitalOut M_Relay;
extern DigitalOut R_Relay;

extern DigitalOut SyncOut;

extern AnalogOut HFAC;

extern DigitalOut led1;
extern DigitalOut led4;


extern DigitalOut shockRedLED;
extern DigitalOut shockGreenLED;

extern DigitalOut chargeRedLED;
extern DigitalOut chargeGreenLED;


extern Serial LCD;
extern Serial pc;
extern int HFAC_Duration;
extern int HFAC_Amplitude;


const double offset = 65535/2;
extern bool byPassStatus ;

extern bool DfebCharged;

extern Timer heartRateTimer; 
extern Timeout deliverTimeout;
extern bool heartRateTimerStart;
extern int heartRate;
extern int heartMeanCounter;
extern int heartRateTemp;
extern bool syncActivate;
extern bool syncShock;

void Delivering(int amplitude, int duration);
void SyncDelivering();
void checkByPass();
void syncInFunc();
void syncInFuncFall();
void buttonLEDs(int led, bool enable); 



#endif