/*This class is meant to interface the MMA7455L digital acceleromter with the mbed micro through a SPI interface.
This class deals mainly with acquiring measurment from the acceleromter, but doesn't deal with pulse detection 
or interrupts, so it needs to be extended*/

#ifndef MMA7455L_SPI_H
#define MMA7455L_SPI_H

#include "mbed.h"

/*declaration of the registers of the MMA7455L accelermoter*/

#define X_OUT                                   0x06
#define Y_OUT                                   0x07
#define Z_OUT                                   0x08
#define STATUS                                  0x09
#define DETECTION_SOURCE_REGISTER               0x0A
#define X_OFF_LSB                               0x10
#define X_OFF_MSB                               0x11
#define Y_OFF_LSB                               0x12
#define Y_OFF_MSB                               0x13
#define Z_OFF_LSB                               0x14
#define Z_OFF_MSB                               0x15
#define MODE_CONTROL                            0x16
#define INTERRUPT_LATCH_RESET                   0x17
#define CONTROL_1                               0x18
#define CONTROL_2                               0x19
#define LEVEL_DETECTION_THRESHOLD_LIMIT         0x1A
#define PULSE_DETECTION_THRESHOLD_LIMIT         0x1B
#define PULSE_DURATION_VALUE                    0x1C
#define LATENCY_TIME_VALUE                      0x1D

/*some useful charechters for writing, reading and checking readiness of data*/
#define READ                                    0x00
#define WRITE                                   0x80
#define DATA_READY                              0x01

               


 class MMA7455L_SPI{
 
 public: 
 
 float Ax,Ay,Az;
 MMA7455L_SPI(PinName, PinName, PinName, PinName); /*mosi, miso, clk and cs*/
 void update_acceleration();
 void set_range_of_measurment(int GS1, int GS0); /*this function takes two bits, zeros ones
                                                   and they are used to determine the required char 
                                                   to be sent to the mode control register*/
//void set_mode_of_operation(int LSB1, int LSB2);                                                 
 
 
 private:
 
 int sensetivity;
 DigitalOut _CS;
 SPI _spi;
 
 /*we declare some basic functions for reading data from accelermoter and writing to the accelermoter**/
 signed char read(char adress);
 void write(char adress, char content);
 
 /*some basic functions that take a char that controls mode of operation and behaviour of the accelermoter*/
 void set_mode(char);
 void set_interrupt_latch_reset_time(char value = 0x03);
 void set_offsets(char, char, char); 
 void set_control_1(char value = 0x00);
 void set_control_2(char value = 0x00);
 void set_level_detection_thershold_limit_value(char value = 0x2F);
 void set_pulse_detection_thershold_limit_value(char value = 0x2F);
 void set_pulse_duration_value(char value = 0x2F);
 void set_latency_time_value(char value =0x2F);
 
 /*some auxillary functions that describes its status*/
 signed char status();
 
 
 
 };
 #endif