#include "MMA7455L_SPI.h" 

MMA7455L_SPI :: MMA7455L_SPI (PinName _mosi, PinName _miso, PinName _clk, PinName _cs):_CS(_cs),_spi(_mosi, _miso, _clk)
{
    /*initializing the main variables (or data members) of the accelermoter class*/
    Ax = 0;
    Ay = 0;
    Az = 0;
    sensetivity = 0;
    _CS = 1; /* just to disable the connection by default, and if we want to enable it _CS = 0 */
    _spi.format(8,0);
    _spi.frequency(8000000);
     set_mode(0x01);
     set_interrupt_latch_reset_time();
     //set_offsets(char, char, char); 
     set_control_1();
     set_control_2();
     set_level_detection_thershold_limit_value();
     set_pulse_detection_thershold_limit_value();
     set_pulse_duration_value();
     set_latency_time_value();
}

signed char MMA7455L_SPI :: read(char adress)
{
    signed char value;
    _CS = 0;
    _spi.write(READ | (adress << 1) );
    value = _spi.write(0x00); /*writing a dummy char ito the register while returning the register
                               content because SPI is an exchange protocol*/
    _CS = 1;                           
    return value;
}

void MMA7455L_SPI :: write(char adress, char content)
{
    _CS = 0;
    _spi.write(WRITE | (adress << 1) );
    _spi.write(content);
    _CS = 1;
}

void MMA7455L_SPI :: set_mode(char reg_mode) /*notice that we operate on measurment mode only*/
{
    write(MODE_CONTROL, reg_mode);
    char g_select_1 = reg_mode & 0x08;
    char g_select_0 = reg_mode & 0x04;
    if ( (g_select_1 == 0) && (g_select_0 == 0) ) /*means we are operating on 8g range*/
    {
        sensetivity = 16; /*the units are "count/g" */
    }
    else if ( (g_select_1 == 0) && (g_select_0 == 1) ) /*means we are operating on 2g range*/
    {
        sensetivity = 64;
    }
    else if ( (g_select_1 == 1) && (g_select_0 == 0) ) /*means we are operating on 4g range*/
    {
        sensetivity = 32;
    }
    
}

void MMA7455L_SPI :: set_range_of_measurment(int GS1, int GS0)
{
    char g_select_1 = GS1 << 3;
    char g_select_0 = GS0 << 2;
    char reg_mode = g_select_1 | g_select_0;
    set_mode(reg_mode);
}

/* these functions may not be useful now, but may be of use if the class is to be extended*/

 void MMA7455L_SPI :: set_interrupt_latch_reset_time(char value)
 {
    write(INTERRUPT_LATCH_RESET, value);
 }
 
 void MMA7455L_SPI :: set_control_1(char value)
 {
    write(CONTROL_1, value);
 }
 void MMA7455L_SPI :: set_control_2(char value)
 {
    write(CONTROL_2, value);
 }
 
 void MMA7455L_SPI :: set_level_detection_thershold_limit_value(char value)
 {
    write(LEVEL_DETECTION_THRESHOLD_LIMIT,value);
 }
 
 void MMA7455L_SPI :: set_pulse_detection_thershold_limit_value(char value)
 {
    write(PULSE_DETECTION_THRESHOLD_LIMIT,value);
 }

void MMA7455L_SPI :: set_pulse_duration_value(char value)
{
    write(PULSE_DURATION_VALUE, value);
}

void MMA7455L_SPI :: set_latency_time_value(char value)
{
    write(LATENCY_TIME_VALUE, value);
}

void MMA7455L_SPI :: set_offsets (char offx, char offy, char offz)
{
    /*this function is not very necessary as the offset values were measured beore and sutracted
    from the readings in the "update_acceleraton()" function ... if you want to know more info, you
    can refer to Freescale MMA7455L data sheet page 24, and Freescale application note AN3745, which 
    describes a procedure for this calibration. */
}

signed char MMA7455L_SPI :: status()
{
    signed char value = 0;
    value = read(STATUS);
    return value;
}

void MMA7455L_SPI :: update_acceleration()
{
    signed char x = 0,y = 0,z = 0;
    if( status() & DATA_READY)  
    {
        x = read(X_OUT);
        Ax = (float)x / sensetivity + 0.1875;
        
        y = read(Y_OUT);
        Ay = (float)y / sensetivity + 0.438;
        
        z = read(Z_OUT);
        Az = (float)z / sensetivity + 1 - 0.562;
    }
}


