#include "mbed.h"
#include "TextLCD.h"

// mbed -> EZ1
// -----------
// VOUT -> +5
// GND  -> GND
// p20  -> AN


TextLCD lcd(p24, p26, p27, p28, p29, p30); // rs, e, d4-d7
AnalogIn ain(p15);

int main() {
    float adc, volts, inches, cm;
    
    while (1){
        lcd.locate(0,0);
        adc = ain.read();           // read analog as a float
        volts = adc * 3.3;          // convert to volts
        inches = volts / (3.3 / 512.0);    // 3.3V supply: 6.4mV per inch
        cm = inches * 2.54;    // inch to cm
        lcd.printf("%8.3f cm\n", cm);

        wait(0.05);                 // 20Hz update rate
    }
}


