#include "mbed.h"
#include "FXOS8700Q.h"

// Initialize Serial port
Serial pc(USBTX, USBRX); // tx, rx
Serial bt(PTC17, PTC16); //For Bluetooth TX, RX


AnalogIn sensorPinTHUMB(A1); // pin that the THUMB flex sensor is attached to
AnalogIn sensorPinINDEX(A2); // pin that the INDEX flex sensor is attached to
AnalogIn sensorPinMIDDLE(A3); // pin that the MIDDLE flex sensor is attached to
AnalogIn sensorPinRING(A4); // pin that the RING flex sensor is attached to
AnalogIn sensorPinPINKY(A5); // pin that the PINKY flex sensor is attached to

DigitalOut Green(PTC3);         // pin that the LED is attached to
DigitalOut Yellow(PTC2);         // pin that the LED is attached to
DigitalOut Blue(PTA2);         // pin that the LED is attached to

//I2C lines for FXOS8700Q accelerometer/magnetometer
FXOS8700Q_acc acc(PTE25, PTE24, FXOS8700CQ_SLAVE_ADDR1);


// variables:
float sensorValueTHUMB = 0;         // the THUMB sensor value
float sensorValueINDEX = 0;         // the INDEX sensor value
float sensorValueMIDDLE = 0;         // the MIDDLE sensor value
float sensorValueRING = 0;         // the RING sensor value
float sensorValuePINKY = 0;         // the PINKY sensor value

float sensorMinTHUMB = 1023;        // minimum THUMB sensor value
float sensorMinINDEX = 1023;        // minimum INDEX sensor value
float sensorMinMIDDLE = 1023;        // minimum MIDDLE sensor value
float sensorMinRING = 1023;        // minimum RING sensor value
float sensorMinPINKY = 1023;        // minimum PINKY sensor value

float sensorMaxTHUMB = 0;           // maximum THUMB sensor value
float sensorMaxINDEX = 0;           // maximum INDEX sensor value
float sensorMaxMIDDLE = 0;           // maximum MIDDLE sensor value
float sensorMaxRING = 0;           // maximum RING sensor value
float sensorMaxPINKY = 0;           // maximum PINKY sensor value

char str[] = "Calibration was Successful";
char c;
int count1 = 0;
int count2 = 0;
int count3 = 0;
int count4 = 0;
int count5 = 0;
int count6 = 0;
int count7 = 0;
int count8 = 0;
int count9 = 0;
int count10 = 0;
int count11 = 0;

int main()
{
   
   
   while(1) {
        if (bt.readable() > 0)  
{       
        c = bt.getc();            
        pc.putc(c); // echo input back to serial
 }
 
// turn on LED to signal the start of the calibration period:
        if(c == '0') {
            
            pc.printf("Request to calibrate the glove\n\r");
            Green = 1; Yellow = 1; Blue = 1;
            pc.printf("Calibration in progress...\n\r");
            pc.printf("Flex, close and open your gloved fist several times\n\r");
            bt.printf("Calibration in progress...\n\r");
            bt.printf("Flex, close and open your gloved fist several times\n\r");
            //wait (100); //Timeout for door to stay open
            //Blue = 0; Red = 0; Green = 1;
            //bt.printf("Door is CLOSED");
       
    // calibrate using the first 100 values 
        int b;
        for ( b = 0; b < 50; b = b + 1)
        {
// Find the max flex sensor values for all 5 fingers
//-------------------------------------------------------------------------            
        
        pc.printf("//--------------------------------------------------------------------------------------------//\n");
        pc.printf("**********************************************************************************************\n");
        pc.printf("//--------------------------------------------------------------------------------------------//\n");
        sensorValueTHUMB = 10 * sensorPinTHUMB.read(); //Find the maximum flex sensor values for the thumb
        if (sensorValueTHUMB > sensorMaxTHUMB) 
        sensorMaxTHUMB = sensorValueTHUMB;
        else
        sensorMaxTHUMB = sensorMaxTHUMB;
        
        if (sensorValueTHUMB < sensorMinTHUMB) //Find the minimum flex sensor values for the thumb
        sensorMinTHUMB = sensorValueTHUMB;
        else
        sensorMinTHUMB = sensorMinTHUMB;
        
        pc.printf("Thumb Flex Sensor Value: %0.4f\n", sensorValueTHUMB);
        
        
        sensorValueINDEX = 10 * sensorPinINDEX.read();   //Find the maximum flex sensor values for the index
        if (sensorValueINDEX > sensorMaxINDEX) 
        sensorMaxINDEX = sensorValueINDEX;
        else
        sensorMaxINDEX = sensorMaxINDEX;
        
        if (sensorValueINDEX < sensorMinINDEX) //Find the minimum flex sensor values for the index
        sensorMinINDEX = sensorValueINDEX;
        else
        sensorMinINDEX = sensorMinINDEX;
        pc.printf("Index Flex Sensor Value: %0.4f\n", sensorValueINDEX);
        
        
        sensorValueMIDDLE = 10 * sensorPinMIDDLE.read(); //Find the maximum flex sensor values for the middle
        if (sensorValueMIDDLE > sensorMaxMIDDLE) 
        sensorMaxMIDDLE = sensorValueMIDDLE;
        else
        sensorMaxMIDDLE = sensorMaxMIDDLE;
        
        if (sensorValueMIDDLE < sensorMinMIDDLE) //Find the minimum flex sensor values for the middle
        sensorMinMIDDLE = sensorValueMIDDLE;
        else
        sensorMinMIDDLE = sensorMinMIDDLE;
        pc.printf("Middle Flex Sensor Value: %0.4f\n", sensorValueMIDDLE);
        
        
        sensorValueRING = 10 * sensorPinRING.read(); //Find the maximum flex sensor values for the Ring
        if (sensorValueRING > sensorMaxRING) 
        sensorMaxRING = sensorValueRING;
        else
        sensorMaxRING = sensorMaxRING;
        
        if (sensorValueRING < sensorMinRING) //Find the minimum flex sensor values for the Ring
        sensorMinRING = sensorValueRING;
        else
        sensorMinRING = sensorMinRING;
        pc.printf("Ring Flex Sensor Value: %0.4f\n", sensorValueRING);
        
        
        sensorValuePINKY = 10 * sensorPinPINKY.read();   //Find the maximum flex sensor values for the PINKY
        if (sensorValuePINKY > sensorMaxPINKY) 
        sensorMaxPINKY = sensorValuePINKY;
        else
        sensorMaxPINKY = sensorMaxPINKY;
        
        if (sensorValuePINKY < sensorMinPINKY) //Find the minimum flex sensor values for the Pinky
        sensorMinPINKY = sensorValuePINKY;
        else
        sensorMinPINKY = sensorMinPINKY;
        pc.printf("Pinky Flex Sensor Value: %0.4f\n", sensorValuePINKY);
    } //end For loop
        
        //Summary of Minimum and Maximum flex sensors
        pc.printf("Max THUMB sensor value: %0.4f, Min THUMB sensor value: %0.4f\n", sensorMaxTHUMB, sensorMinTHUMB);
        pc.printf("Max INDEX Sensor Value: %0.4f, Min INDEX sensor Value: %0.4f\n",  sensorMaxINDEX, sensorMinINDEX);
        pc.printf("Max MIDDLE Sensor Value: %0.4f, Min MIDDLE sensor Value: %0.4f\n", sensorMaxMIDDLE, sensorMinMIDDLE);
        pc.printf("Max RING Sensor Value: %0.4f, Min RING sensor Value: %0.4f\n", sensorMaxRING, sensorMinRING);
        pc.printf("Max PINKY Sensor Value: %0.4f, Min PINKY sensor Value: %0.4f\n", sensorMaxPINKY, sensorMinPINKY);
        bt.printf("%s", str);  //send successful calibration message to phone
        Green = 0; Yellow = 0; Blue = 0;
       
        return 0; 
} // End If Loop for c=0

if(c == '1') {
    
    acc.enable();       //enable K64f accelerometer
    float faX, faY, faZ; //declare variables to use x,y and z acelerator values
    int16_t x = 0;      //
    int16_t y = 0;
    int16_t z = 0;
            
            
        Green = 1; //turn the GREEN LED on to indicate glove is ready for use
            
        acc.getX(&faX);
        acc.getY(&faY);
        acc.getZ(&faZ);
        x = 10*faX;
        y = 10*faY;
        z = 10*faZ;
    
            
// read the sensors:
    sensorValueTHUMB = 10 * sensorPinTHUMB.read();
    sensorValueINDEX = 10 * sensorPinINDEX.read();
    sensorValueMIDDLE = 10 * sensorPinMIDDLE.read();
    sensorValueRING = 10 * sensorPinRING.read();
    sensorValuePINKY = 10 * sensorPinPINKY.read();
    
    pc.printf("thumb: %0.4f, index: %0.4f, middle: %0.4f, ring: %0.4f, pinky: %0.4f, gyro: x= %d, y= %d, z= %d \n\r", sensorValueTHUMB, sensorValueINDEX, sensorValueMIDDLE, sensorValueRING, sensorValuePINKY,  x, y, z);
    //bt.printf("thumb: %0.4f, index: %0.4f, middle: %0.4f, ring: %0.4f, pinky: %0.4f, gyro: %0.4f,  x= %d, y= %d, z= %d \n\r", sensorValueTHUMB, sensorValueINDEX, sensorValueMIDDLE, sensorValueRING, sensorValuePINKY,  x, y, z);
   
    
    
   
    if((8.591 < sensorValueTHUMB && sensorValueTHUMB < 8.8207)&& (-2 < x && x < 4)){
        pc.printf("A %s\n");
        count8 = count8 + 1;
        if (count8 == 1)
        { 
        bt.printf("A, ");
        }
        }
     if((7.3513 < sensorValueTHUMB && sensorValueTHUMB < 7.5873)){
        pc.printf("B %s\n");
          count9 = count9 + 1;
        if (count9 == 1)
        { 
        bt.printf("B, ");
        }
        }
        
     if((7.8727 < sensorValueTHUMB && sensorValueTHUMB < 8.1166) && (7.9865 < sensorValueMIDDLE && sensorValueMIDDLE < 9.0965) && (8.3113 < sensorValueINDEX && sensorValueINDEX < 8.7227) && (-3 < x && x < 1)){
        pc.printf("C %s\n");
          count10 = count10 + 1;
        if (count10 == 1)
        { 
        bt.printf("C ");
        }
        }

     if((8.0125 < sensorValueINDEX && sensorValueINDEX < 8.2077) && (-11 < y && y < -7) ){
        pc.printf("D %s\n");
        count11 = count11 + 1;
        if (count11 == 1)
        { 
        bt.printf("D ");
        }
        }
    
     /*

     if((8.1634 < sensorValueTHUMB && sensorValueTHUMB < 8.656) && (8.7664 < sensorValueINDEX && sensorValueINDEX < 8.9605) && (8.5954 < sensorValueMIDDLE && sensorValueMIDDLE < 8.9223) && (7.3604 < sensorValueRING && sensorValueRING < 7.668) && (7.7595 < sensorValuePINKY && sensorValuePINKY < 8.4056) && (-2 < x && x < 1) && (-11 < y && y < -8) && (-3 < z && z < 1)){
        pc.printf("1 %s\n");
        bt.printf("1 %s");
        }

     if((7.9514 < sensorValueTHUMB && sensorValueTHUMB < 8.3063) && (8.625 < sensorValueINDEX && sensorValueINDEX < 8.9257) && (7.4993 < sensorValueMIDDLE && sensorValueMIDDLE < 7.7451) && (7.3913 < sensorValueRING && sensorValueRING < 7.6589) && (7.7869 < sensorValuePINKY && sensorValuePINKY < 8.1549) && (-2 < x && x < 1) && (-10 < y && y < -8) && (-3 < z && z < 0)){
        pc.printf("2 %s\n");
        bt.printf("2 %s");
        }

     if((8.1123 < sensorValueTHUMB && sensorValueTHUMB < 8.7055) && (8.2755 < sensorValueINDEX && sensorValueINDEX < 8.8242) && (7.5541 < sensorValueMIDDLE && sensorValueMIDDLE < 8.0875) && (7.3887 < sensorValueRING && sensorValueRING < 7.6744) && (7.269 < sensorValuePINKY && sensorValuePINKY < 7.5112) && (-1 < x && x < 1) && (-11 < y && y < -9) && (-2 < z && z < 1)){
        pc.printf("3 %s\n");
        bt.printf("3 %s");
        }


     if((7.3772 < sensorValueTHUMB && sensorValueTHUMB < 7.6766) && (7.4785 < sensorValueINDEX && sensorValueINDEX < 7.7242) && (7.6021 < sensorValueMIDDLE && sensorValueMIDDLE < 7.8327) && (7.4167 < sensorValueRING && sensorValueRING < 7.6906) && (8.0097 < sensorValuePINKY && sensorValuePINKY < 8.3341) && (-1 < x && x < 1) && (-1 < y && y < -8) && (-2 < z && z < 1)){
        pc.printf("4 %s\n");
        bt.printf("4 %s");
        }


     if((7.4744 < sensorValueTHUMB && sensorValueTHUMB < 7.7179) && (7.6393 < sensorValueINDEX && sensorValueINDEX < 7.7652) && (7.6108 < sensorValueMIDDLE && sensorValueMIDDLE < 7.8421) && (7.4869 < sensorValueRING && sensorValueRING < 7.7123) && (7.2608 < sensorValuePINKY && sensorValuePINKY < 7.4977) && (-1 < x && x < 1) && (-10 < y && y < -8) && (-3 < z && z < 0)){
        pc.printf("5 %s\n");
        bt.printf("5 %s");
        }
*/

     /*
     if((8.0029 < sensorValueMIDDLE && sensorValueMIDDLE < 8.5487) && (-10 < x && x < -7) && (-5 < y && y < 1) && (-4 < z && z < 3)){
        pc.printf("We are %s\n");
        count1 = count1 + 1;
        if (count1 == 1)
        { 
        bt.printf("We are ");
        }
        }

     if((-3 < x && x < 2) && (-4 < y && y < 0) && (7< z && z < 11)){
        pc.printf("Group %s\n");
        count2 = count2 + 1;
        if (count2 == 1)
        { 
        bt.printf("Group ");
        }
        }
      

     if((8.5806 < sensorValueINDEX && sensorValueINDEX < 9.189) && (-3 < x && x < 1) && (-11 < y && y < -8) && (-1 < z && z < 1)){
        pc.printf("12, %s\n");
         count3 = count3 + 1;
        if (count3 == 1)
        { 
      bt.printf("12, ");
        }
        }
        
     if((-4 < x && x < 0) && (-1 < y && y < 2) && (-10 < z && z < -7)){
        pc.printf("this is a %s\n");
         count4 = count4 + 1;
        if (count4 == 1)
        { 
       bt.printf("this is a ");
       }
        }
        
     if((7.7686 < sensorValueRING && sensorValueRING < 8.012) && (7.8952 < sensorValuePINKY && sensorValuePINKY < 8.249) && (-7< x && x < -4) && (-10 < y && y < -7) && (-5 < z && z < 2)){
        pc.printf("to speech %s\n");
         count5 = count5 + 1;
        if (count5 == 1)
        { 
       bt.printf("to speech ");
        }
        }

     if((0 < x && x < 4) && (-10 < y && y < -7) && (-5 < z && z < -1)){
        pc.printf("sign %s\n");
         count6 = count6 + 1;
        if (count6 == 1)
        { 
       bt.printf("sign ");
        }
        }
        
     if((8.4366 < sensorValueINDEX && sensorValueINDEX < 9.008) && (8.7243 < sensorValueMIDDLE && sensorValueMIDDLE < 9.2045) && (8.8161 < sensorValueRING && sensorValueRING < 9.2164) && (7.2151 < sensorValuePINKY && sensorValuePINKY < 7.6333) && (-2 < z && z < 2)){ 
        pc.printf("project %s\n");
         count7 = count7 + 1;
        if (count7 == 1)
        { 
       bt.printf("project.");
    }
          
}*/
  



}
}
}
 