#include "mbed.h"
#include "hcsr04.h"
#include "MFRC522.h"

//Test of cheap 13.56 Mhz RFID-RC522 module 
//Adapted for Nucleo STM32 F401RE. Should work on other Nucleos too


// Nucleo Pin for MFRC522 reset (pick another D pin if you need D8)
#define MF_RESET    D8

//Connect as follows:
//RFID pins        ->  Nucleo header CN5 (Arduino-compatible header)
//----------------------------------------
//RFID IRQ=pin5    ->   Not used. Leave open
//RFID MISO=pin4   ->   Nucleo SPI_MISO=PA_6=D12
//RFID MOSI=pin3   ->   Nucleo SPI_MOSI=PA_7=D11
//RFID SCK=pin2    ->   Nucleo SPI_SCK =PA_5=D13
//RFID SDA=pin1    ->   Nucleo SPI_CS  =PB_6=D7
//RFID RST=pin7    ->   Nucleo         =PA_9=D6
//3.3V and Gnd to the respective pins   

// Initialize Serial port
Serial pc(USBTX, USBRX); // tx, rx
Serial bt(PTC17, PTC16); //For Bluetooth TX, RX

//Initialize sensor and set pins
HCSR04  usensor(PTB9,PTA1); //Pins for motion detector: Trigger, Echo
DigitalOut Red(PTC4); //Pin used for red light
DigitalOut Green(PTC12); //Pin used for green light
DigitalOut Blue(PTD0); //Pin used for blue light
DigitalOut LedBlue(LED3);//LED light on the board

//MFRC522    RfChip for RFID pins  (SPI_MOSI, SPI_MISO, SPI_SCK, SPI_CS, MF_RESET)
MFRC522    RfChip   (D11, D12, D13, D7, D6);

unsigned int dist;       
char c;

int main()
{
        //Green light needs to be ON at idle to prove system is active and ready
       Blue = 0; Green = 1; Red = 0;  //Turn the Green light on and all others off
       LedBlue = 1;
       
  pc.printf("starting...\n");

  
  RfChip.PCD_Init();
        
    while(1) {

    // Init. RC522 Chip and HCSR04 motion Sensor
    
     usensor.start();
//**************************************************************************************         
//******************************Motion sensor begin*************************************
  
  dist=usensor.get_dist_cm();
  
  if (dist < 200) 
{
        printf("AMBER ALERT - Motion is detected within (cm) (%1d)\r\n", dist);
        bt.printf("AMBER ALERT - Motion is detected within (cm) (%1d)\r\n", dist);
        Red = 1;
        Green = 0;
        Blue = 0;
        wait_ms(2);    
}
       
        else
{
        printf("Motion is detected within (cm) (%1d)\r\n", dist);
        Green = 1;
        Red = 0;
        Blue = 0;
        wait_ms(2); 
        bt.printf(" \r\n", dist);
}
//**************************************************************************************         
//********************Bluetooth and Android App Code************************************
if (bt.readable() > 0)  
{        
         c = bt.getc();            
            pc.putc(c); // echo input back to serial
        if(c == '1') {
            Blue = 1; Red = 0; Green = 0;            
            pc.printf("Door is OPEN from Android App!\n\r");
            bt.printf("Door is OPEN\n\r");
            bt.printf("Door will be closed within 10s");
            wait (10); //Timeout for door to stay open
            Blue = 0; Red = 0; Green = 1;
            bt.printf("Door is CLOSED");
            }
       /* if(c == '0') {
            Green = 0; Blue = 0;Red = 1;
            pc.printf("Door is CLOSED from Android App!\n\r");
            bt.printf("Door is CLOSED");
            wait(3);
            Red = 0; Green = 1;
                 }*/
                 
        } 
                      
       
//**************************************************************************************
//******************************Code for RFID*******************************************
    
    // Look for new cards
    if ( ! RfChip.PICC_IsNewCardPresent())
    {
      wait_ms(10);
      continue;
    }

    // Select one of the cards
   if ( ! RfChip.PICC_ReadCardSerial())
    {
      wait_ms(10);
      continue;
    }
        printf("ACCESS ALLOWED using RFID tag.\r\n");
        bt.printf("ACCESS ALLOWED using RFID tag. Door is OPEN\r\n");        
        bt.printf("Door will be closed within 10s");
        Red = 0; Green = 0; Blue = 1;
        wait(5);
        Blue = 0; Red = 0; Green = 1;
        bt.printf("Door is CLOSED.\r\n");
       
    if(dist < 200)
    {
        Red = 1; Green = 0; Blue = 0;  
        //LedBlue = 1;
        
    }
        else 
    {
        Red = 0; Green = 1; Blue = 0;  
        //LedBlue = 1;
    }


    // Print Card UID
    pc.printf("Card UID: ");
    for (uint8_t i = 0; i < RfChip.uid.size; i++)
    {
      pc.printf(" %X02", RfChip.uid.uidByte[i]);
    }
    pc.printf("\n\r");

    // Print Card type
    uint8_t piccType = RfChip.PICC_GetType(RfChip.uid.sak);
    pc.printf("PICC Type: %s \n\r", RfChip.PICC_GetTypeName(piccType));
    wait_ms(10);

    }
}
 