#include "mbed.h"
#include "Keypad.h"
#include "TextLCD.h"
#include <string>

#define PW_SIZE 5
#define PASSWORD "1234A"

Serial pc(USBTX, USBRX);

//initialize LCD display
TextLCD lcd(p5, p7, p6, p11, p12, p13, p14, TextLCD::LCD16x2); // rs, rw, e, d0-d3

// Define keypad values
char Keytable[] = { '1', '2', '3', 'A',   // r0
                    '4', '5', '6', 'B',   // r1
                    '7', '8', '9', 'C',   // r2
                    '*', '0', '#', 'D'    // r3
                  };
                 // c0   c1   c2   c3

//Initialize variables
uint32_t Index;
std::string  pword;
const char * parray;
int psize=0;

uint32_t cbAfterInput(uint32_t index) {
    Index = index;
    
    //print entered value on LCD and save password in string
    if(Keytable[Index] != '#' && Keytable[Index] != '*'){
        if(psize < PW_SIZE){
            pword.push_back(Keytable[Index]);
            lcd.putc(Keytable[Index]);
            parray = pword.c_str();
            psize++;
        }
    }
    
    if(Keytable[Index] == '*'){
        pword = "";
        lcd.cls();
        wait(0.001);
        lcd.printf("Pass:");
        lcd.locate(0,1);
        psize=0;
    }
    if(Keytable[Index] == '#'){
        lcd.cls();
        wait(0.001);
        if(pword == PASSWORD)
            lcd.printf("Correct");
        //lcd.printf("pword");
        //lcd.locate(0,1);
        //lcd.printf(parray);
        else
            lcd.printf("Incorrect");
    }
    return 0;
}

    
int main() {
    
    lcd.cls();
    wait(0.001);
    lcd.printf("Pass:");
    lcd.locate(0,1);
     
                // r0   r1   r2   r3   c0   c1   c2   c3
    Keypad keypad(p28, p27, p26, p25, p21, p22, p23, p24);
    keypad.attach(&cbAfterInput);
    keypad.start();  // energize the keypad via c0-c3

    while (1) {
        __wfi();
        pc.printf("Interrupted\r\n");
        pc.printf("Index:%d => Key:%c\r\n", Index, Keytable[Index]);        
    }
}