#include "mbed.h" 
#include "MCP23017.h" // include 16-bit parallel I/O header file 
#include "WattBob_TextLCD.h" // include 2*16 character display header file 

#define BACK_LIGHT_ON(INTERFACE) INTERFACE->write_bit(1,BL_BIT) 
#define BACK_LIGHT_OFF(INTERFACE) INTERFACE->write_bit(0,BL_BIT) 

DigitalIn   IP_wave(p5);               //input of the square wave,1s
DigitalIn   DIP_SW1(p6);               //digital input ,switch1,400ms
DigitalIn   DIP_SW2(p7);               //switch2,400ms
AnalogIn    AIP_1(p19);              //Analog input1800ms
AnalogIn    AIP_2(p20);              //AIP 2800ms

DigitalOut  bit4(LED1);             //each bits of led
DigitalOut  bit3(LED2);
DigitalOut  bit2(LED3);
DigitalOut  bit1(LED4);

int S_wave,switch1,switch2 = 0;   //check the value of square wave, switches
float Anal_val1[4],Anal_val2[4] = {0,0,0,0};    //for calculating the values of analog inputs

int freq = 0;                      // frequency of the wave
float aver_anl1,aver_anl2 = 0;     //average values of analog inputs
int ero_code = 0;                  // error code
int flag_task3 = 0;                //flag for task3

int run_task = 0;                  //if run_task = 1,running led
int led_show = 0;                  //led blinksing in incremental ways

MCP23017 *par_port; // pointer to 16-bit parallel I/O object 
WattBob_TextLCD *lcd; // pointer to 2*16 chacater LCD object 
Timer tmr;            //define a timer for calculating the frequency
Timer Tcheck;                           //define a timer for testing whether task1 is overtime of not

LocalFileSystem local("local"); //Create the local filesystem under the name "local"
FILE *fp;           //define a file

void iniLCD()       //initial LCD
{   
    par_port = new MCP23017(p9, p10, 0x40); // initialise 16-bit I/O chip 
    lcd = new WattBob_TextLCD(par_port); // initialise 2*26 char display 
    par_port->write_bit(1,BL_BIT); // turn LCD backlight ON 
    lcd->cls();
    lcd->locate(0,0);
}

void iniFile()      //create file
{
    fp = fopen("/local/data.txt", "w");  // Open "data.txt" on the local file system for writing
    fprintf(fp,"freqency, Digital value, Analog value1, Analog value2\n");
    fclose(fp);
    }

void T1_checkWave()                        //get the frequency of the wave,works
{
    float tm_val1,tm_val2 = 0;
    int flag,flag_err = 0;
               
    Tcheck.reset();                 //to check wether the testing is over time or not
    Tcheck.start();
              
    
        
    while(IP_wave)
    {   
        tm_val2 = Tcheck.read();
        flag = tm_val2*1000;
        
        if(flag >= 10)                    //if the signal keeps hi in 20ms , it will end testing. the flag_err will be set one
            {
                flag_err = 1;             
                break;
            }
        }

    while( !IP_wave ) 
    {    
        tm_val2 = Tcheck.read();
        flag = tm_val2*1000;
        
        if((flag >= 20) || flag_err == 1)                    //if the signal keeps low in 50ms , it will end testing.
            {
                flag_err = 1;
                break;
            }
    }
    Tcheck.stop();
    
    if( flag_err == 0 )
    {
    tmr.reset();
    tmr.start();
    while( IP_wave )
    {

        }
    tmr.stop();
    
    tm_val1 = tmr.read_us();
    }
    
    if( tm_val1 > 500.0 )               //if impulse last more than 500us, it will get its frequency
        freq = 500000/tm_val1;                               //the frenquency of the wave
    else 
        freq = 0;

    }

void T2_checkSW()                                   //check the SWes per 400ms,works
{
    if( DIP_SW1 != 0 )
        switch1 = 1;
    else switch1 = 0;
    
    if( DIP_SW2 !=0 )
        switch2 = 1;
    else switch2 = 0;
    
}

void T3_checkAIP()                          //get the values of analog inputs per 800MS
{   
    float para1,para2;
    Anal_val1[flag_task3] = AIP_1.read();
    Anal_val2[flag_task3] = AIP_2.read();
    
    flag_task3++;
    flag_task3 = flag_task3%4;
    
    para1 = (Anal_val1[0] + Anal_val1[1] + Anal_val1[2] + Anal_val1[3])*3.3;        //filt the values
    para2 = (Anal_val2[0] + Anal_val2[1] + Anal_val2[2] + Anal_val2[3])*3.3;
    aver_anl1 = para1/4;
    aver_anl2 = para2/4;
}   
    
void T4_display()              //dispaly each values per 2s
{
    int aver_show;
/*           get frequency from task 1          */
//      frequency is freq


/*           get digital value from task2       */    
/*      digital number = {switch1,switch2} 


*/
/*           get average value from task3,show integers       */                                                                        
//data type of aver_anl1,aver_anl2 are float


    aver_show = (aver_anl1+aver_anl2)/2;

/*           get error code from task5          */
//              ero_code


/*           show them!!                        */

    lcd->cls();
    lcd->locate(0,0);
    lcd->printf("F=%d Aval=%d",freq,aver_show);
    lcd->locate(1,0);
    lcd->printf("Dval=%d%d ErC=%d",switch2,switch1,ero_code);    
    
}


void T5_SWtask()                             //check the values of switches and run the task , set error code per 1.8s
{
    if((switch1 == 1) && (aver_anl1 > aver_anl2))   ero_code = 3;
    else ero_code = 0;                              //error code
    
    if(switch2 == 1)   
        run_task = 1;
    else 
        run_task = 0;
    
}

void RunLed()                                 //blink led 1.5s
{
    led_show = led_show%16;    
    int num_led = led_show;
    
    if(num_led > 7) {num_led = num_led - 8; bit4 = 1; }
    else bit4 = 0;
    
    if(num_led > 3) {num_led = num_led - 4; bit3 = 1;}
    else bit3 = 0;
    
    if(num_led > 1) {num_led = num_led - 2; bit2 = 1;}
    else bit2 = 0;
    
    bit1 = num_led;    
    led_show++;
}
    
void T6_saveData()              //save data in uSD;
{
    fp = fopen("/local/data.txt", "a");         //open file and add data into the file
    fprintf(fp,"%d, _%d%d, %f, %f\n",freq,switch2,switch1,aver_anl1,aver_anl2);
    fclose(fp);                                 //close file
    
    }

int main()
{
    iniLCD();
    iniFile();
    int tick = 0;
    lcd->printf("Initializing!");
    while(1)
    {
        wait(0.1);               
        tick++;
        if(tick%50 == 0)
            T6_saveData();
            
        if(tick%20 == 0)
            T4_display();
            
        if(tick%18 == 0)
            T5_SWtask();
            
        if((tick%15 == 0) && (run_task ==1 ))
            RunLed();
            
        if(tick%10 == 0)
            T1_checkWave(); 
            
        if(tick%8 == 0)
            T3_checkAIP();
            
        if(tick%4 == 0)
            T2_checkSW();
            
        if(tick == 1800) tick = 1;    
        }
    return 0;
    }

