/* mbed Microcontroller Library
 * Copyright (c) 2018 u-blox AG
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "mbed.h"
#include "sensirion_ess.h"
I2C i2c(D14,D15);
SensirionESS  sensirionESS(&i2c);
int main()
{
	 printf("u-blox C030 Demo with Sensirion Environmental Sensor Shield\r\n");

     if (sensirionESS.initSensors() != 0) {
       printf("Error while initializing sensors: %s\n",sensirionESS.getError());
       return -1;
     }
     sensirionESS.setLedRYG(1,1,1);
     printf("Sensirion ESS initialized successfully..\r\n");
     printf("Detected sensor %s on kit\r\n", sensirionESS.getProductType()  ? "SGPC3" : "SGP30");
     wait(3);

     while (1){
         if (sensirionESS.measureIAQ() !=0){
             printf("Error reading IAQ: %s\r\n",sensirionESS.getError());
        	 return -1;
         }
         if (sensirionESS.measureRHT()!=0) {
             printf("Error reading RHT: %s\n",sensirionESS.getError());
        	 return -1;
         }
         printf("Temperature: %.2f		Humidity: %.2f\n"
        		 "tVOC  Concentration: %.2fppb	CO2eq Concentration: %.2fppm\r\n",sensirionESS.getTemperature(),sensirionESS.getHumidity(),\
				 sensirionESS.getTVOC(),sensirionESS.getECO2());
         wait(1);
     }
}
