#include "MicroBit.h"

extern "C" {
#include    "fmif.h"
};
#include    "fmsd1.h"

//MicroBit uBit;
MicroBitDisplay uBitDisplay;
MicroBitMessageBus uBitMessageBus;
MicroBitButton buttonA(MICROBIT_PIN_BUTTON_A, MICROBIT_ID_BUTTON_A);
//MicroBitI2C i2c(I2C_SDA0, I2C_SCL0);

int tnum = 60;

const ManagedString tname[12] = {
    "C","c","D","d","E","F","f","G","g","A","a","B"
};

void onButtonA(MicroBitEvent)
{
    uBitDisplay.print(tname[tnum-60]);
}

int main( void )
{
//    uBit.init();

    initSPI();
    initSD1();
    Fmdriver_init();

    Fmdriver_sendMidi(0xc0);
    Fmdriver_sendMidi(0x04);

    uBitMessageBus.listen(MICROBIT_ID_BUTTON_A, MICROBIT_BUTTON_EVT_CLICK, onButtonA);

    while(1){
//        if ( buttonA.isPressed() ){
//            Fmdriver_sendMidi(0x90);
//            Fmdriver_sendMidi(0x30);
//            Fmdriver_sendMidi(0x7f);
//        }

        Fmdriver_sendMidi(0x90);
        Fmdriver_sendMidi(tnum);
        Fmdriver_sendMidi(0x7f);
        wait_ms(200);
        Fmdriver_sendMidi(0x90);
        Fmdriver_sendMidi(tnum);
        Fmdriver_sendMidi(0);
        wait_ms(200);
        tnum++;
        if ( tnum>72 ){ tnum=60;}
    }

    return 0;
}