#include "MicroBit.h"

SPI ymf825(MOSI, MISO, SCK);
MicroBitPin ss(MICROBIT_ID_IO_P16,MICROBIT_PIN_P16,PIN_CAPABILITY_DIGITAL);
MicroBitPin rst(MICROBIT_ID_IO_P8,MICROBIT_PIN_P8,PIN_CAPABILITY_DIGITAL);

//extern MicroBit uBit;
//#define   ss    uBit.io.P16
//#define   rst   uBit.io.P8

void writeSingleCPP( unsigned char adrs, unsigned char data )
{
    ss.setDigitalValue(0);  //  select slave
    ymf825.write(adrs);
    ymf825.write(data);
    ss.setDigitalValue(1);
    wait_ms(1);
}
extern "C" void writeSingle( unsigned char adrs, unsigned char data ){ writeSingleCPP(adrs,data);}
extern "C" void writeBurst( unsigned char adrs, unsigned char* data, int count )
{
    ss.setDigitalValue(0);
    ymf825.write(adrs);
    for (int i = 0; i<count; i++) {
        ymf825.write(*(data + i));
    }
    ss.setDigitalValue(1);
    wait_ms(1);
}
extern "C" void delayMs( int ms ){ wait_ms(ms);}

void initSPI(void)
{
    //  init SPI
    ymf825.format(8);   //  mode=0
    ymf825.frequency(4000000);

}
void initSD1( void )
{
    //  1.  powerOnReset( void );
    rst.setDigitalValue(0);

    //  2. wait 100usec
    wait_us(100);

    //  3.  RST_N : high
    rst.setDigitalValue(1);

    //  4.  DRV_SEL : low
    writeSingleCPP(29, 1);  //  3.3v

    //  5.  AP0 : 0
    writeSingleCPP(2, 0x0e);

    //  6.  wait for Quarz stability
    wait_ms(1);

    //  7.  CLKE : "1"
    writeSingleCPP(0, 0x01);

    //  8.  ALRST : low
    writeSingleCPP(1, 0x00);

    //  9.  SFTRST  :   0xa3
    writeSingleCPP(26, 0xa3);
    wait_ms(1);

    //  10. SFTRST  :   0x00
    writeSingleCPP(26, 0x00);

    //  11. wait 30msec
    wait_ms(30);

    //  12. AP1 AP3: "0"
    writeSingleCPP(2, 0x04);

    //  13. wait 10usec
    wait_us(10);

    //  14. AP2: "0"
    writeSingleCPP(2, 0x00);

    writeSingleCPP(25, 0xcc);   //  -32[dB]
    writeSingleCPP(27, 0x3f);   //  set itp max
    writeSingleCPP(20, 0x00);   //  set itp on
    writeSingleCPP(3, 0x01);    //  amp gain(6.5[dB])
    writeSingleCPP(9, 0xf8);    //  Sequencer Volume
}