#include "ShortBeacon.h"
ShortBeacon Shortbeacon;
Serial rosh(USBTX, USBRX);           // tx, rx
SPI spi(p5, p6, p7);               // mosi, miso, sclk
DigitalOut cs(p8);                 //slave select or chip select

int j = 0;                           //for hk[]
int n = 0;                           //for bit number
uint8_t hk[HK_DATA_LEN_SHORT]; 

unsigned char mask_table[] = { 0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x01 };      //to extract individual bits from MSB to LSB

uint8_t const callsign[] = { 0xAB, 0x8A, 0xE2, 0xBB, 0xB8, 0xA2, 0x8E };              //without bitstuffing, additional zero at end!  

void writereg(uint8_t reg,uint8_t val)           //function to initialize RFM69 registers
{
    cs = 0;
    __disable_irq();
    spi.write(reg | 0x80);      
    spi.write(val);
    __enable_irq();
    cs = 1;
}

uint8_t readreg(uint8_t reg)                     //function to read from RFM69 registers
{
    int val;
    cs = 0;
    __disable_irq();
    spi.write(reg & ~0x80);        
    val = spi.write(0);
    __enable_irq();
    cs = 1;
    return val;
}
 
void bitstuffinghk(uint8_t byte)                 //function to repeat each bit of hk[] 16 times
{
    bool bit_n;
    for(n=0; n<8; n++)
    {
        bit_n = ( byte & mask_table[ n ] ) != 0x00;
        if(bit_n!=0)
        {
            hk[j]= 0xFF;
            hk[j+1]= 0xFF;
         }    
        else
        {
            hk[j]= 0x00;
            hk[j+1]= 0x00;
        }    
    j=j+2;
   } 
}

void FUNC_SHORTBEACON() 
{
    wait(0.5);                          
    uint8_t fifo_full = 0x00,fifo_thresh;            
    int i = 0;                           //for callsign[]
    int u = 0;                           //universal count for hk array
    int bar = 0;
    uint8_t rval=0x00;
    cs = 1;                              // Chip must be deselected

    spi.format(8,0);                     //8 bits taken at a time
    spi.frequency(10000000);             //10MHz SCLK frequency (Maximum possible for RFM69HCW)
    
    //initialization
    
    //Common configuration registers
    writereg(0x01,0x04);       //Sequencer off, Standby mode
    writereg(0x02,0x08);       //Packet Mode, OOK Modulation, No DC Free Mechanism
    writereg(0x03,0x68);       //Signalling Rate = 1200bps
    writereg(0x04,0x2B);       //Signalling Rate = 1200bps
    writereg(0x07,0x6C);       //6C D0 0B for 435 MHz
    writereg(0x08,0xD0);       //435 MHz
    writereg(0x09,0x0B);       //435 MHz   
    
    //Packet Engine Registers
    writereg(0x2C,0x00);        //set Preamble length to 0
    writereg(0x2D,0x00);        //set Preamble length to 0
    writereg(0x2E,0x08);        //SyncWord off
    writereg(0x37,0x00);        //Fixed Length, CRC and SyncAddress off
    writereg(0x38,0xF0);        //payload length = 240 bytes
    writereg(0x3C,0x28);        //Fifothresh = 40 bytes
        
    //Initialization of Registers complete
    
    //Bitstuffing of HK Parameters, appending to hk[]
    
    for(i=0;i<UNSTUFFED_CALLSIGN_LEN;i++)
    {
        bitstuffinghk(callsign[i]);
    }
        
    bitstuffinghk(Shortbeacon.Voltage[0]);
    bitstuffinghk(Shortbeacon.AngularSpeed[0]);
    bitstuffinghk(Shortbeacon.AngularSpeed[1]);
    bitstuffinghk(Shortbeacon.SubsystemStatus[0]);
    bitstuffinghk(Shortbeacon.Temp[0]);
    bitstuffinghk(Shortbeacon.Temp[1]);
    bitstuffinghk(Shortbeacon.Temp[2]);
    bitstuffinghk(Shortbeacon.ErrorFlag[0]);
    
    //Filling Data into FIFO (first 66 bytes)   
                  
    cs = 0;
    __disable_irq();
    spi.write(0x80);            //fifo write access
    __enable_irq();
    
    for(i=0;i<66;i++)
    {
        __disable_irq();    
        spi.write(hk[i]);          
        __enable_irq();
    }
    
    u=i;
    cs = 1;
                                
    //check for fifofull
    while(fifo_full != 0x80)
    {
        fifo_full = readreg(0x28);
        fifo_full = fifo_full & 0x80;
    }
                                            
    //Set to Tx mode
    writereg(0x01,0x0C);    //Transmit mode set after FIFO is full
    
    //Highpower settings
    writereg(0x11,0x7F);    //RegPalevel (20db)                
    writereg(0x13,0x0F);    //RegOCP
    writereg(0x5A,0x5D);    //RegTestPa1
    writereg(0x5C,0x7C);    //RegTestPa2

    //Check for fifoThresh
    fifo_thresh = 0x08;
    while(fifo_thresh != 0x00)
    {
        fifo_thresh = readreg(0x28);
        fifo_thresh = fifo_thresh & 0x20;   //5th bit
    } 
    
    while(u<=HK_DATA_LEN_SHORT)
    {
        
        if((HK_DATA_LEN_SHORT - u) > TIMES)
            bar = TIMES;

        else
            bar = (HK_DATA_LEN_SHORT - u)%TIMES;
            
        //writing again
        cs = 0;
        __disable_irq();
        spi.write(0x80);
        __enable_irq();
        
        for(i=0; i<bar;i++)                  //write 20 bytes of hk[] each time FIFO gets emptied below FifoThresh
        {
            __disable_irq();
            spi.write(hk[u + i]);
            __enable_irq();
        }
        
        u = u + i;
        cs = 1;
                        
        //Check for fifoThresh
        fifo_thresh = 0x08;
        while(fifo_thresh != 0x00)
        {
            fifo_thresh = readreg(0x28);
            fifo_thresh = fifo_thresh & 0x20;   //5th bit
        }
    }
            
    //Checking if PacketSent goes high
    
    while(rval != 0x08)
    {
        rval = readreg(0x28);
        rval = rval & 0x08;
        rosh.printf("sending... \n"); 
    }
    
    rval = 0;
    rosh.printf("packet sent!!! \n");
    rosh.printf("%d",u);    

    //Switch back to Standby Mode
    writereg(0x01,0x04);
    wait(5);                           
}
