#include "mbed.h"
#include "rtos.h"
#include "hkfinal.h"
#include "slave.h"
#include "ShortBeacon.h"
//What da ??
Serial pc(USBTX, USBRX);

DigitalOut led1(LED1);

Timer t;
Timer t1;

Thread *ptr_t_hk_acq;
Thread *ptr_t_acs;
Thread *ptr_t_acs_write2flash;
Thread *ptr_t_bea;
Thread *ptr_t_bea_telecommand;
Thread *ptr_t_sc;

//----------------------------------------------HOUSE-KEEPING(HK)------------------------------------------------------------------------------------------
//void func_hk_mux()
//{
//    pc.printf("Something related to mux\n");
//}
//
//void func_hk_adc()
//{
//    pc.printf("Converting analog to digital\n");
//}
//
//void func_hk_write2flash()
//{
//    pc.printf("Writing the house keeping data to flash\n");
//}
//
//void func_hk_readram()
//{
//    pc.printf("Reading hk data from ram\n");
//}

//void func_hk_send2cdms()
//{
//    pc.printf("Send the data to sd card\n");
//}

void t_hk_send2cdms(void const *args)
{
    while(1)
    {
        t.start();
        
        printf("The state of hk_acq thread is %d\n",ptr_t_hk_acq->get_state());
        printf("The state of acs_main thread is %d\n",ptr_t_acs->get_state());
        printf("The state of acs_write2flash thread is %d\n",ptr_t_acs_write2flash->get_state());
        printf("The state of beacon thread is %d\n",ptr_t_bea->get_state());
        Thread::signal_wait(0x4);
        //func_hk_readram();
        //func_hk_send2cdms();
        FUNC_I2C_SLAVE_MAIN();
        printf("The time to execute send2cdms is %f\n",t.read());
        t.reset();
    }
}

void t_hk_acq(void const *args)
{
    Thread thread_2(t_hk_send2cdms);
    while(1)
    {
        Thread::signal_wait(0x2);
        printf("\nTHIS IS HK\n");
        t.start();
        //func_hk_mux();
        //func_hk_adc();
        //func_hk_write2flash();
        FUNC_HK_MAIN();
        thread_2.signal_set(0x4);
        printf("The state of hk_acq thread is %d\n",ptr_t_hk_acq->get_state());
        printf("The state of acs_main thread is %d\n",ptr_t_acs->get_state());
        printf("The state of acs_write2flash thread is %d\n",ptr_t_acs_write2flash->get_state());
        printf("The state of beacon thread is %d\n",ptr_t_bea->get_state());
        t.stop();
        printf("The time to execute hk_acq is %f seconds\n",t.read());
        t.reset();
    }
}

//---------------------------------------------------------------------------------------------------------------------------------------

typedef struct {
    float mag_field;
    float omega;
    } sensor_data;
    
Mail <sensor_data, 16> q_acs;
    
void func_acs_readdata(sensor_data *ptr)
{
    pc.printf("Reading the data\n");
    ptr -> mag_field = 10;
    ptr -> omega = 3;
}

void func_acs_ctrlalgo()
{
    pc.printf("Executing control algo\n");
}

void func_acs_pwmgen()
{
    pc.printf("Generating PWM signal\n");
}

void func_acs_write2flash(sensor_data *ptr2)
{
    pc.printf("The magnetic field is %.2f T\n\r",ptr2->mag_field);
    pc.printf("The angular velocity is %.2f rad/s\n\r",ptr2->omega);
}

void t_acs(void const *args)
{
    while(1)
    {
        Thread::signal_wait(0x1);
        printf("\nTHIS IS ACS\n");
        t.start();
        sensor_data *ptr = q_acs.alloc();
        func_acs_readdata(ptr);
        func_acs_ctrlalgo();
        func_acs_pwmgen();
        q_acs.put(ptr);
        printf("The state of hk_acq thread is %d\n",ptr_t_hk_acq->get_state());
        printf("The state of acs_main thread is %d\n",ptr_t_acs->get_state());
        printf("The state of acs_write2flash thread is %d\n",ptr_t_acs_write2flash->get_state());
        printf("The state of beacon thread is %d\n",ptr_t_bea->get_state());
        printf("The time to execute t_acs is %f seconds\n",t.read());
            //   Thread::wait(10000);
        t.reset();
    }
}

void t_acs_write2flash(void const *args)
{
    while(1)
    {
        //printf("Writing in the flash\n");
        osEvent evt = q_acs.get();
        if(evt.status == osEventMail)
        {
            sensor_data *ptr = (sensor_data*)evt.value.p;
            func_acs_write2flash(ptr);
            q_acs.free(ptr);
        }
        printf("Writing in the flash\n");
    }
}

//---------------------------------------------------BEACON--------------------------------------------------------------------------------------------

int flag=0;

/*void func_bea_readbaeflash()
{
        pc.printf("Reading data from beacon flash\n");
        wait(0.01);
}

void func_bea_spiwrite()
{
    pc.printf("Writing through SPI\n");
    wait(0.01);
}
*/
void t_bea_telecommand(void const *args)
{
    char c = pc.getc();
    if(c=='a')
    {
        pc.printf("Telecommand detected\n");
        flag=1;
    }
}

void t_bea(void const *args)
{
    
    while(1)
    {
        Thread::signal_wait(0x3);
        printf("\nTHIS IS BEACON\n");
        t.start();
        printf("The state of hk_acq thread is %d\n",ptr_t_hk_acq->get_state());
        printf("The state of acs_main thread is %d\n",ptr_t_acs->get_state());
        printf("The state of acs_write2flash thread is %d\n",ptr_t_acs_write2flash->get_state());
        printf("The state of beacon thread is %d\n",ptr_t_bea->get_state());
        if(flag==0)
        {
            //func_bea_readbaeflash();
            //func_bea_spiwrite();
            Thread::wait(30000);
        }
        else
        {
            Thread::wait(10000);
            flag = 0;
        }
        
        printf("The time to execute beacon thread is %f seconds\n",t.read());
        t.reset();
    }
}

//------------------------------------------------------------------------------------------------------------------------------------------------
int i=0;
void t_sc(void const *args)
{
    
    printf("The value of i in scheduler is %d\n",i);
    if(i%10==0)
    {
        ptr_t_acs -> signal_set(0x1);
    }
    if(i%20==0)
    {
        ptr_t_hk_acq -> signal_set(0x2);
    }
    if(i%30==0)
    {
        ptr_t_bea -> signal_set(0x3);
    }
    i++;
}
    
//---------------------------------------------------------------------------------------------------------------------------------------------

int main()
{
    t1.start();
    
    ptr_t_hk_acq = new Thread(t_hk_acq);
    ptr_t_acs = new Thread(t_acs);
    ptr_t_acs_write2flash = new Thread(t_acs_write2flash);
    ptr_t_bea = new Thread(t_bea);
    ptr_t_bea_telecommand = new Thread(t_bea_telecommand);
    //ptr_t_sc = new Thread(t_sc);

    ptr_t_acs->set_priority(osPriorityRealtime);
    ptr_t_hk_acq->set_priority(osPriorityHigh);
    ptr_t_acs_write2flash->set_priority(osPriorityBelowNormal);
    ptr_t_bea->set_priority(osPriorityAboveNormal);
    ptr_t_bea_telecommand->set_priority(osPriorityIdle);
    //ptr_t_sc->set_priority(osPriorityAboveNormal);
    
    /*RtosTimer for individual thread-------------------------------------------------------------------------------------------
    RtosTimer t_hk_acq_timer(t_hk_acq, osTimerPeriodic);
    RtosTimer t_acs_timer(t_acs, osTimerPeriodic);    
    RtosTimer t_bea_timer(t_bea, osTimerPeriodic);
    
    t_hk_acq_timer.start(20000);
    t_acs_timer.start(10000);
    t_bea_timer.start(30000);
    ----------------------------------------------------------------------------------------------*/    
    
    RtosTimer t_sc_timer(t_sc,osTimerPeriodic);
    t_sc_timer.start(1000);
    printf("%f\n",t1.read());   
    while(1)
    {
        ;
    }
    
}