 // mbos Blinky demonstration.
 // Task 1 toggles LED1 every second, under control of a timer. It then posts an event to
 // task 2 which flashed LED2 briefly.
 #include "mbed.h"                    
 #include "mbos.h"

 #define TASK1_ID                1       // Id for task 1 (idle task is 0)
 #define TASK1_PRIO              95      // priority for task 1
 #define TASK1_STACK_SZ          64      // stack size for task 1 in words 
 #define TASK2_ID                2       // Id for task 2 
 #define TASK2_PRIO              65      // priority for task 2
 #define TASK2_STACK_SZ          64      // stack size for task 2 in words 
 #define TIMER0_ID               0       // Id for timer 0
 #define TIMER0_PERIOD           1000    // Time period in milliseconds
 #define TIMER0_EVENT            1       // Event flag (1 << 0)
 #define T1_TO_T2_EVENT          2       // Event flag (1 << 1)

LocalFileSystem local("local"); 
 FILE *fp ;
 void task1(void);                       // task function prototypes
 void task2(void);

 DigitalOut led1(LED1);
 DigitalOut led2(LED2);
 mbos os(2, 1);                          // Instantiate mbos with 2 tasks & 1 timer    
  int i=0;
 int main(void)
 {
    FILE *fp = fopen("/local/out.txt", "w");
     // Configure tasks and timers
     os.CreateTask(TASK1_ID, TASK1_PRIO, TASK1_STACK_SZ, task1);
     os.CreateTask(TASK2_ID, TASK2_PRIO, TASK2_STACK_SZ, task2);
     os.CreateTimer(TIMER0_ID, TIMER0_EVENT, TASK1_ID);
     // Start mbos
     os.Start();
     // never  return!
 }

 void task1(void)
 {
     os.SetTimer(TIMER0_ID, TIMER0_PERIOD, TIMER0_PERIOD);
     while(i<15){
         os.WaitEvent(TIMER0_EVENT);
         led1 = !led1;
         i++;
        
     }
 }

 void task2(void)
 {
     while(i<15){
       
         led2 = !led2;
         fprintf(fp, "Hello World!");
          
         wait_ms(100);
        
     }
     fclose(fp);
 }
