#include "DTH22.h"

DTH22::DTH22(PinName DATAsignal ) : DTH22pin(DATAsignal)
{
    for(int i = 0; i < MAXRAWDATA; i++) {
        rawdata[i] = false;
    }
}

DTH22::~DTH22() {}

int DTH22::getTH(int *temp,int *humidity)
{
    signed short int bytes[5];
    int checksumtest = 0;
    bool tempsign = false;
    DTH22::getraw();
    DTH22::getrawbits();
    // check transmission type errors
    if(transmissionErrors()!=0) return transmissionErrors();
    // group bits into bytes
    for(int j = 0; j < 5; j++) {
        bytes[j] = 0;
        for(int i = 0; i < 8; i++) {
            if(rawdatabits[(i+(j*8))]==true) bytes[j]=bytes[j] | 1;
            if(i!=7) bytes[j]=bytes[j] << 1;
        }
    }
    // checksum error test
    for(int i = 0; i < 4; i++) {
        checksumtest += bytes[i];
    }
    checksumtest = checksumtest & 255;  // only want the last byte for test
    if(checksumtest!=bytes[4]) return CHECKSUMFAIL ;
    // get rH
    *humidity = (int)((bytes[0] << 8) | bytes[1]);
    // get temp
    if((bytes[2]&128)!=0) tempsign = true;
    bytes[2] = bytes[2] & 127;
    *temp = (int)((bytes[2] << 8) | bytes[3]);
    if(tempsign) *temp = -*temp;
    return 0;
}

int DTH22::getDTH11TH(int *temp,int *humidity){
    signed short int bytes[5];
    int checksumtest = 0;
//    bool tempsign = false;
    DTH22::getraw();
    DTH22::getrawbits();
    // check transmission type errors
    if(transmissionErrors()!=0) return transmissionErrors();
    // group bits into bytes
    for(int j = 0; j < 5; j++) {
        bytes[j] = 0;
        for(int i = 0; i < 8; i++) {
            if(rawdatabits[(i+(j*8))]==true) bytes[j]=bytes[j] | 1;
            if(i!=7) bytes[j]=bytes[j] << 1;
        }
    }
    // checksum error test
    for(int i = 0; i < 4; i++) {
        checksumtest += bytes[i];
    }
    checksumtest = checksumtest & 255;  // only want the last byte for test
    if(checksumtest!=bytes[4]) return CHECKSUMFAIL ;
    // get rH
    *humidity = (int)(bytes[0] * 10);
    // get temp
    //if((bytes[2]&128)!=0) tempsign = true;
    //bytes[2] = bytes[2] & 127;
    *temp = (int)(bytes[2] * 10);
    //if(tempsign) *temp = -*temp;
    return 0;    
}
int DTH22::testing(bool *bits,signed short int *data,int *temp,int *humidity)
{
    signed short int bytes[5];
    int checksumtest = 0;
    bool tempsign = false;
    DTH22::getraw();
    DTH22::getrawbits();
    for(int i = 0; i < 40; i ++) {
        bits[i]=rawdatabits[i];
    }
    if(transmissionErrors()!=0) return transmissionErrors();
    // group bits into bytes
    for(int j = 0; j < 5; j++) {
        bytes[j] = 0;
        for(int i = 0; i < 8; i++) {
            if(rawdatabits[(i+(j*8))]==true) bytes[j]=bytes[j] | 1;
            if(i!=7) bytes[j]=bytes[j] << 1;
        }
    }
    // checksum test
    for(int i = 0; i < 4; i++) {
        checksumtest += bytes[i];
    }
    checksumtest = checksumtest & 255;  // only want the last byte for test
    if(checksumtest!=bytes[4]) return CHECKSUMFAIL ;
    // get rH
    *humidity = (int)((bytes[0] << 8) | bytes[1]);
    // get temp
    if((bytes[2]&128)!=0) tempsign = true;
    bytes[2] = bytes[2] & 127;
    *temp = (int)((bytes[2] << 8) | bytes[3]);
    if(tempsign) *temp = -*temp;
    for(int i = 0; i < 5; i++) {
        data[i]=bytes[i];
    }
    return 0;
}
void DTH22::getraw()
{
    int counter = 0;
    for(int i = 0; i < 100; i++) {
        timingData[i] = 0;
    }
    DTH22pin.mode(OpenDrain);
    DTH22pin.output();
    DTH22pin = 0;
    wait_ms(18);
    DTH22pin = 1;
    wait_us(40);
    DTH22pin.input();
    for (int i = 0; i < MAXRAWDATA; i++) {
        int junk = DTH22pin.read();
        if(junk==0) rawdata[i] = false;
        if(junk==1) rawdata[i] = true;
        wait_us(BITREADTIME);
    }
    for (int j = 0; j < 100; j++) {
        if(counter < MAXRAWDATA) {
            timingData[98] = counter ;
            timingData[j] = transistionCount(counter);
            if(timingData[j]>=MAXBITCOUNT) {
                j = 101;
            } else {
                counter = counter + timingData[j] ;
            }
        } else {
            j = 101;
        }
    }
}

int DTH22::transistionCount(int index)
{
    int count = 0;
    bool endbit = !rawdata[index];

    for (int i = 1; i < MAXBITCOUNT; i++) {
        if(rawdata[index + i]==endbit) {
            count = i;
            i = MAXBITCOUNT;
        }
    }
    return count;
}

int DTH22::transmissionErrors()
{
    if(timingData[83]!=0) {
        return DATANOISE ;
    }
    for(int i = 2; i < 81; i += 2) {
        if(!((timingData[i]>=(STARTTRANSBITSIZE - 2))||(timingData[i]<=(STARTTRANSBITSIZE + 2)))) {
            return STIMINGFAIL ;
        }
    }
    if(timingData[98]>=(MAXRAWDATA - MAXBITCOUNT)) {
        return DATANOISE2 ;
    }
    return 0;
}

void DTH22::getrawbits()
{
    int counter = 0;
    bool bitvalue = false;
    for(int i=2; i < 81; i += 2) {
        if(timingData[i+1]>=timingData[i]) bitvalue = true;
        rawdatabits[counter++] = bitvalue;
        bitvalue = false;
    }
}
