#include <string.h>
#include "mbed.h"
#include "rtos.h"
#include "TextLCD.h"

Serial keyboard(USBTX, USBRX);

int PacemakerA, PacemakerV = 0;
DigitalOut Apace(), Vpace();
DigitalIn Aget(), Vget();

int PacemakerModeGuard = 0;
int observationInterval = 10000;

void PacemakerSense() {
    
}

// Keyboard and ModeSwitch thread
void PacemakerKeyboard() {
    while(1) {
        char c = keyboard.getc();
        switch(c) {
            case 'n':
            case 'N':
                PacemakerModeGuard = 0;
                break;
            case 's':
            case 'S':
                PacemakerModeGuard = 1;
                break;
            case 'e':
            case 'E':
                PacemakerModeGuard = 2;
                break;
            case 'm':
            case 'M':
                PacemakerModeGuard = 3;
                break;
            case 'a':
            case 'A':
                if(PacemakerModeGuard == 3) {
                    PacemakerA = 1;
                    Thread::wait(10);
                    PacemakerA = 0;
                }
                break;
            case 'v':
            case 'V':
                if(PacemakerModeGuard == 3) {
                    PacemakerV = 1;
                    Thread::wait(10);
                    PacemakerV = 0;
                }
                break;
            case 'o':
            case 'O':
                char buff[3];
                keyboard.gets(buff, 3);
                int newObs;
                if(sscanf(buff, "%i", &newObs) != 0) {
                    observationInterval = newObs;
                }
                break;
            case default:
                break;
        }
    }
}

void PacemakerDisplay() {
    
}

void PacemakerAlarm() {
    
}

void PacemakerLED() {
    
}



int main() {
    
}