#include "mbed.h"
#include "Serial.h"

//XBEE Connection
Serial xbee1(p9, p10);//XBEE (p3 DIN, p2 DOUT)<--> mbed (tx,rx)
DigitalOut rst1(p8);//XBee pin 5
DigitalIn xbee_power(p11);//XBEE Power Indicator (XBee pin 13)
DigitalOut xpower_LED(LED1);//XBEE Power LED <---> mbed LED1
DigitalIn xbee_associate(p12);//XBEE Association Digital In
DigitalOut xassociate_LED(LED2);//XBEE Association LED <---> mbed LED2




//PC Serial
Serial pc(USBTX, USBRX);

int main() {

    // reset the xbees (at least 200ns)
    rst1 = 0;   
    wait_ms(1); 
    rst1 = 1;    
    wait_ms(1); 
 
    while(1) {
     if(xbee_power) //XBEE Power Check        
          xpower_LED = 1;
        else   
          xpower_LED = 0;
        
        if(xbee_associate)//XBEE Association Check
           xassociate_LED = 1;
        else
           xassociate_LED = 0;
           
           
        if(pc.readable()) {//User Entering Data
            xbee1.putc(pc.getc());//Transmit Data Entered By User (mbed tx <--> xbee DIN)
  //          wait(0.03);
        }
        if(xbee1.readable()) {//XBEE 2 Received Data (xbee DOUT <--> mbed rx)
            pc.putc(xbee1.getc());//Print Data Received
//           wait(0.03);
        }
    }
}