#include "mbed.h"
#include "Serial.h"


//File Handling
#define FSNAME "msc"
#include "MSCFileSystem.h"
MSCFileSystem msc(FSNAME);

//Gas Consumption Variable
unsigned GasCounter = 0;

//Time Handling
struct tm TIME;
Timer TimeIn_Filter;


//PC Serial for DEBUG Messages
Serial pc(USBTX, USBRX);


//Time Update
InterruptIn TimeIn(p21);//Push Button input for Time Reset (minimum > 2V)

//XBee Range Check
InterruptIn RangeIn(p22);//Push Button input for XBee Range Check

//XBEE Connection
Serial xbee(p9, p10);//XBEE Dout (xbee p2) <--> mbed rx p10, XBEE Din (xbee p3) <--> mbed tx p9
DigitalOut xbee_reset(p8);//XBEE Reset (xbee p5) <--> mbed digital out p8
DigitalIn xbee_power(p11);//XBEE Power Indicator (xbee p13) Digital In
DigitalIn xbee_associate(p12);//XBEE Association (xbee p15) Digital In
DigitalIn xbee_CTS(p13);//XBEE pin 12 CTS High = Signal to stop data transfer over UART
DigitalOut xbee_sleep(p14);//XBEE SLEEP_RQ (p9)
//unsigned xbeeon_off = 0;//Default OFF

//Indicators

DigitalOut XBeePower(LED1);//User can now power off
DigitalOut XBeeAssoc(LED2);//XBee Associate
DigitalOut XBeeRange(LED2);//XBee Range Check Indication
DigitalOut CounterLog(LED3);//Counter Log Activity
DigitalOut PushButton(LED3);//Bush Button Indication
DigitalOut Time(LED4);//Time Based Activity

//Functions


unsigned ClockSet();//Called at sensor input

void TimeInterrupt();//Called at p21 high -> Clock Update Interrupt
void TimeInterrupt() {//Called at p21 high -> Clock Update Interrupt
    pc.printf("/nTimeInterrupt Called\n");///////..............DEBUG

    /*    if ((TimeIn_Filter.read()) == 0) {

            TimeIn_Filter.start();
            pc.printf("/nTimeInterrupt Timer Started\n");///////..............DEBUG

            PushButton = 1;
        }

      while (1) {
        if ((TimeIn_Filter.read() >= 2)) {//All readings within 2 sec from first call ignored as noise

    pc.printf("/nTimeInterrupt Timer >=2 \n");///////..............DEBUG
    */
    while ( (ClockSet() != 1) );//Till TIME.txt is not found

    /*TimeIn_Filter.stop();
    TimeIn_Filter.reset();
    pc.printf("/nTimeInterrupt Timer Stoped\n");///////..............DEBUG
    PushButton = 0;
    }*/
//}
}


unsigned ClockSet() {
    pc.printf("\nClockSet Called\n");///////////..........DEBUG
    FILE *TimeUpdate;
    TimeUpdate = fopen( "/" FSNAME "/TIME.txt", "r");

    if (TimeUpdate == NULL) {//File Not Found
        pc.printf("\nERROR: TIME.txt not found\n");//////......DEBUG


        //LED4 File not Found Indication
        Time = 1;
        wait(0.2);
        Time = 0;
        wait(0.2);
        Time = 1;
        wait(0.2);
        Time = 0;
        Time = 1;
        wait(0.2);
        Time = 0;

        return 0;
    } else {

        //01:34->T
        //01/34/67->Y
        char T[10], Y[20];
        fscanf(TimeUpdate,"%s%s",T,Y);


        char h[3] = {T[0], T[1], '\0'};//01:34->T
        char mi[3] = {T[3], T[4], '\0'};
        char d[3] = {Y[0], Y[1], '\0'};//01/34/67->Y
        char mo[3] = {Y[3], Y[4], '\0'};
        char y[5] = {Y[6], Y[7], Y[8], Y[9], '\0'};

        //Converting String to int and stroing in tm structure
        TIME.tm_hour = atoi(h);
        TIME.tm_min = atoi(mi);
        TIME.tm_mday = atoi(d);
        TIME.tm_mon = atoi(mo);
        TIME.tm_year = atoi(y) ;

        // Adjust for tm structure required values
        TIME.tm_year = TIME.tm_year - 1900;//Number of years since 1900 (windows)
        TIME.tm_mon = TIME.tm_mon - 1;//Jan

        //mbed time update
        set_time(mktime(&TIME));//broket time converted to simple time and passed to set_time (sets system time)

        //LED4 Time Update Indication
        Time = 1;
        wait(2);
        Time = 0;

        // display the time
        /*
                        char HourMin[10], Calandar[12];
                        while (1) {
                            time_t seconds = time(NULL);//CURRENT TIME
                            TIME = *localtime(&seconds);//TO BROKEN TIME
                            strftime(HourMin, sizeof(HourMin), "%T", &TIME);//FORMATTED OUTPUT
                            strftime(Calandar, sizeof(Calandar), "%d/%m/%Y", &TIME);
                            pc.printf("\n%s %s", HourMin, Calandar);
                            wait(1);
                        }

        */
    }
    fclose(TimeUpdate);//Close File Handler
    return 1;//Time Updated Successfully

}

void XBeeRangeCheck_Indication(unsigned status);
void XBeeRangeCheck_Indication(unsigned status) {//LED4 is Flashed (Indicating previous shut down was not safe)
    if (status == 1) {
        for (unsigned i=0; i<=5 ; i++) {
            XBeeRange = 1;
            wait(0.2);
            XBeeRange = 0;
            wait(0.2);
            XBeeRange = 1;
            wait(0.2);
            XBeeRange = 0;
        }

    } else {
        XBeeRange = 0;
        wait(4);
    }
}





unsigned Xbee_RangeCheck();//XBEE Range Check (Check for END DEVICE)
unsigned Xbee_RangeCheck() {

    char response[5];
    wait(10);//Allow Time For Communication
    for (int i=1 ; i<=3 ; i++) {//Enter XBEE in AT Command Mode
        xbee.putc('+');
        wait(0.05);
    }
    xbee.scanf("%s",response);//Get Xbee Response
    //pc.printf("\n%s\n",response);//////////////...........DEBUG

    //XBEE IS IN COMMAND MODE AND OK RESPONSE IS READ
    xbee.printf("ATDNREADER");//AT(AT Command Mode) DN(Destination Node Command) LOGGER(Node Identifier "NI" for END DEVICE)
    xbee.putc('\r');//Carriage Return
    xbee.scanf("%s",response);//Get Response
    //pc.printf("\n%s\n",response);/////////////.............DEBUG
    xbee.printf("ATCN");
    xbee.putc('\r');
    if (response[0] == 'E') {//Could Not Find End Device ("ERROR"\r returned)
        pc.printf("\nCound not find END DEVICE\n");/////////.............DEBUG
        //EndDevice_Indication();
        return 0;//Return No End Device

    } else {//End Device is Active ("OK"\r returned)
        pc.printf("\nEnd Device Responded\n");/////////.............DEBUG
        return 1;//Return End Device is ON
    }
}


void RangeIn_Handler();
void RangeIn_Handler() {
    if (Xbee_RangeCheck())//Meter Reader is ON
        XBeeRangeCheck_Indication(1) ;//Flash LED 2
    else//Meter Reader is OFF
        XBeeRangeCheck_Indication(0);//LED2 off for 4 sec
}
void Xbee_Reset();//Reset xbee
void Xbee_Reset() {
    pc.printf("\nXBee_Reset called");//////////..........DEBUG
    xbee_reset = 0;//RESET
    wait_ms(1);
    xbee_reset = 1;//Back To Operation
    wait_ms(1);
}


unsigned RTS();
unsigned RTS() {//returns 1 when mbed is Clear To Send
    if (xbee_CTS == 0) return 1;//mbed is Clear To Send
    else return 0;
}



void nocsv_indication();
void nocsv_indication() {//Flash LED2 => NO END DEVICE
    for (unsigned i=0; i<=5 ; i++) {
        CounterLog = 1;
        wait(0.2);
        CounterLog = 0;
        wait(0.2);
        CounterLog = 1;
        wait(0.2);
        CounterLog = 0;
    }
}


unsigned Reading_Handler();//Manage "GasCounter" Log File "GAS.csv"
unsigned Reading_Handler() {
    pc.printf("\nReading_Handler called\n");///...........DEBUG

    FILE *csv;
    csv = fopen( "/" FSNAME "/GAS.csv", "rb+");

    if (csv == NULL) {//File Not Found
        pc.printf("\nERROR: GAS.csv not found\n");


        return 0;//File not found
    }

    fseek(csv,0,SEEK_END);//Move File Pointer at End of File

    char HourMin[10], Calandar[12];
    time_t seconds = time(NULL);//GET CURRENT TIME
    TIME = *localtime(&seconds);//CURRENT TIME TO BROKEN TIME

    //EXCEL SUPPORTED FORMATTED OUTPUT
    strftime(HourMin, sizeof(HourMin), "%T", &TIME);
    strftime(Calandar, sizeof(Calandar), "%d/%m/%Y", &TIME);

    //Printing To GAS.csv
    fprintf(csv,"%u,%s,%s\n",GasCounter, HourMin, Calandar);


    fclose(csv);
    return 1;//GAS.csv UPDATED
}


int main() {

    TimeIn.rise(&TimeInterrupt);//p21 Push Buttor (Update mbed clock)
    RangeIn.rise(&RangeIn_Handler);//p22 Push Buttor (Flash LED2 if found else LED2 off for 4 s)

    ClockSet();
    // pc.printf("\nReached Here\n");//////..............DEBUG
    Xbee_Reset();

    while (1) {
        //pc.printf("Entered While");
        XBeePower = xbee_power;
        XBeeAssoc = xbee_associate;
        if (xbee.readable()) {
            if (xbee.getc() == '*') {//Next is counter value
                xbee.scanf("%u", &GasCounter);
                //wait(0.2);
                //xbee.putc('R');//Reading Received
                //xbee.putc('\r');
                //wait(0.2);
                pc.printf("\n%u", GasCounter);//////////........DEBUG
                if (  Reading_Handler() != 1) {//GAS.csv not updated
                    //ERROR INDICATION
                    nocsv_indication();
                } else {
                    //READING SUCCESSFUL LOG INDICATION
                    CounterLog = 1;
                    wait(2);//LED3 ON for 2 sec
                    CounterLog = 0;

                }

                // TO VIEW COMPLETE WIRELESS DATA
                //pc.putc(xbee.getc());
            }
        }
    }

}