#include "mbed.h" // Include the library of Mbed
#include "C12832.h"  // Include the library of the specific LCD

DigitalOut yellowled(p5, 1); // Initializing the yellow light ON (same as yellowled = 1)
DigitalOut redled(p7, 0); // Initializing the Red light to OFF (same as redled = 0)
InterruptIn pedestrianbutton(p6);

C12832 lcd(SPI_MOSI, SPI_SCK, SPI_MISO, p8, p11); // create an instance of LCD

int state = 0;  // State variable indicating that YELLOW LIGHT IS ON

char pedestrianAdvert[] = "2 COFFEES FOR THE PRICE OF 1. ONLY AT CAMELIA";
char carDriverAdvert[] = "RECEIVE 5%% REDUCTION ON YOUR FULL TANK ....";

#define YELLOWBLINKINGDURATION 10
#define REDLIGHTONDURATION 15


/**
 * Blinking a yellow LED.
 *
 * @param duration length of time to blink .
 */
static void yellowblinking(int duration){
    int counter=0; 
    while(counter < duration)
    {
        counter+=1;
        yellowled = !yellowled;
        wait(1);
    }
    yellowled = 0;
}

/**
 * Crossing pedestrian.
 *
 * @param duration length of time for pedestrian to cross.
 */
static void pedestriancrossing(int duration){
    redled = 1;
    int counter=0; 
    while(counter < duration)
    {
        counter+=1;
        wait(1);
    }
    redled = 0;
    yellowled = 1;
}

/**
 * Display content on LCD.
 *
 * @param advert The advertising text to be displayed.
 */
static void display(char *advert) {
    lcd.cls();  // Clear LCD
    lcd.locate(10, 5); // get cursor to position x=3px and y=5px
    lcd.printf(advert); // Write text into LCD buffer
    lcd.copy_to_lcd();
}


/**
 * Callback (Interrupt Service Routine) when a bouton is clicked.
 *
 */
void pedestrian_isr() {
     wait(1);
     if (state == 0) // YELLOW IS ON AND RED IS OFF
     {
        state = 1; // YELLOW IS BLINKING AND RED IS OFF
        display(pedestrianAdvert);
        yellowblinking(YELLOWBLINKINGDURATION);
        wait(1);
        state = 2;  // YELLOW IS OFF AND RED IS ON
        display(carDriverAdvert);
        pedestriancrossing(REDLIGHTONDURATION);
        state = 0;
        lcd.cls();
     }
     if(state == 2) // RED 
     {
         // extend the duration of RED by 5 seconds
     }
}

int main() {
    pedestrianbutton.rise(&pedestrian_isr); // Registering an ISR for button click
    while (1) { // DO FOREVER 
       wait(1);
    }
}



