/*
 * Inventor's kit for micor:bit
 * Experiment 3: Dimming an led using a potentiometer
*/

#include "MicroBit.h"

MicroBit uBit;
int light_state;

void onPressed(MicroBitEvent evt)
{
    if (light_state == 0)
        light_state = 1;
    else
        light_state = 0;
}

int main()
{
    // Initialise the micro:bit runtime.
    uBit.init();
    
    // Initialize the light off
    light_state = 0;
    
    // P0 is connected to a push button
    MicroBitPin P0(MICROBIT_ID_IO_P0, MICROBIT_PIN_P0, PIN_CAPABILITY_ALL);

    // listen to pressed (touch) event of button   
    P0.eventOn(MICROBIT_PIN_EVENT_ON_TOUCH);
    uBit.messageBus.listen(MICROBIT_ID_IO_P0, MICROBIT_BUTTON_EVT_CLICK, onPressed , MESSAGE_BUS_LISTENER_IMMEDIATE);

    while (1)
    {
        // state is set by push button P0
        if (light_state == 1)
        {
            // get the value from the potentiometer P1 and write it to the led (P2) brightness
            uBit.io.P2.setAnalogValue(uBit.io.P1.getAnalogValue());
        }
        else 
        {
            uBit.io.P2.setAnalogValue(0);
        }
    }
}

