/*
 * A compass out of a micro:bit
 */
#include "MicroBit.h"

MicroBitI2C i2c(I2C_SDA0, I2C_SCL0); 
MicroBitAccelerometer accelerometer(i2c);
MicroBitCompass compass(i2c, accelerometer);
MicroBitDisplay display;
MicroBitCompassCalibrator compassCalibrator(compass, accelerometer, display);
MicroBitEvent microBitEvent;

int heading = 0;    // the compass heading relative to magnetic north
int heading_precision = 5;  // precision used to detect direction

MicroBitImage arrow("0,0,255, 0,0\n0,255,255,255,0\n255,0,255,0,255\n0,0,255,0,0\n0,0,255,0,0\n");
MicroBitImage delta("0,0,255, 0,0\n0,255,0,255,0\n0,255,0,255,0\n255,0,0,0,255\n255,255,255,255,255\n");

MicroBitButton buttonA(MICROBIT_PIN_BUTTON_A, MICROBIT_ID_BUTTON_A);
MicroBitButton buttonB(MICROBIT_PIN_BUTTON_B, MICROBIT_ID_BUTTON_B);

void displayDelta()
{
    display.print(delta);
    display.scroll(heading_precision);
}

int main()
{
    // Write something to the display
    // need this to "initialize" the display 
    // need this to make the calibation working?
    display.print(arrow);
    // display the current precision
    displayDelta();
    
    // Perform a calibration of the compass t gain reliable values.
    if (compass.calibrate() == MICROBIT_CALIBRATION_REQUIRED)
    {
        compassCalibrator.calibrate(microBitEvent);
    }
    if (compass.isCalibrated() == 0)
        display.scroll("E1"); 


    while(1)
    {
        if (buttonA.isPressed())
        {
            if (heading_precision < 15)
                heading_precision++;
            displayDelta();
        }
        else if (buttonB.isPressed())
        {
            if (heading_precision > 1)
                heading_precision--;
            displayDelta();
        }
        
        // Gets the current heading of the device, relative to magnetic north.
        // If the compass is not calibrated, it will raise the 
        //   MICROBIT_COMPASS_EVT_CALIBRATE event.
        // TODO: do I need this?
        compass.updateSample();
        heading = compass.heading();
        if (heading == MICROBIT_CALIBRATION_IN_PROGRESS)
        {
            display.scroll("E2"); 
            continue;
        }
        
        // draw the rose
        // display.scroll(heading);
        // display North
        if (heading < heading_precision)
            display.print(arrow);
        else if (heading < 45)
            display.print("N");
            
        // display East (arrow 130-140)
        else if (heading < (135-45-heading_precision))
            display.print("E");
        else if (heading < (135-45+heading_precision))
            display.print(arrow);
        else if (heading < (135-heading_precision))
            display.print("E");

        // display South
        else if (heading < (225-45-heading_precision))
            display.print("S");
        else if (heading < (225-45+heading_precision))
            display.print(arrow);
        else if (heading < (225-heading_precision))
            display.print("S");

        // display West
        else if (heading < (315-45-heading_precision))
            display.print("W");
        else if (heading < (315-45+heading_precision))
            display.print(arrow);
        else if (heading < 315)
            display.print("W");
        
        // display North
        else if (heading < (360-heading_precision))
            display.print("N");
        else
            display.print(arrow);
            
        // TODO: use buttons to inc, dec precision
        // need a Micorbit::instance here
        wait_ms(100);
        
     }
}

