#ifndef DISPLAY_H
#define DISPLAY_H

#define RS_f = 1
#define RW_f = 2
#define CS1_f = 4
#define CS2_f = 8

#include "mbed.h"
#include "font.h"

class Display  {
    public:
        // Constructor:
        Display (PinName _RS, PinName _RW, PinName _E, PinName _CS1, PinName _CS2, PinName DB0, PinName DB1, PinName DB2, PinName DB3, PinName DB4, PinName DB5, PinName DB6, PinName DB7);
        // Send write command to Display
        // Page 0-7, y 0-127
        void write (int page, int y, unsigned int data);
        // 
        void SetAddress(int);
        int SendCommand(unsigned int, int);
        // Row 0-7, col 0-122
        void writec(int row, int Y, int c);
        
    private:
        int prevPage;
        int prevY;
        BusInOut DB;
        DigitalOut RS;
        DigitalOut RW;
        DigitalOut E;
        DigitalOut CS1;
        DigitalOut CS2;
        int CurCol;
};

class DisplayTTY : public Stream {
    public:
        DisplayTTY (Display *d, int _row, int _startY, int _numOfChars=10, int _numOfRows=1, int _charOffset=6, int _flags=0);
        void cls();
    protected:
        virtual int _putc (int c);
        virtual int _getc();
        virtual void newline();
        Display *kalle;
        int row;
        int startY;
        int numOfChars;
        int numOfRows;
        int charOffset;
        int flags;
        int CursPosY;
        int CursPosW;
};

#endif