/* 
ELEC2645 Embedded Systems Project 
School of Electronic & Electrical Engineering 
University of Leeds 
Name: Haoyan Zhang
Username: el17h2z
Student ID Number: 201199698
Date: 14/05/2020
 */ 
 
 ///////// pre-processor directives ////////
#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "StarcraftEngine.h"

#define BATTLESHIP_HEIGHT 6
#define BATTLESHIP_WIDTH 4
#define LASER_HEIGHT 2
#define LASER_WIDTH 1
#define SWARM_HEIGHT 6
#define SWARM_WIDTH 6 
#define SWARM_SPEED 1
#define BOSS_HEIGHT 4
#define BOSS_WIDTH 6
#define ACID_HEIGHT 3
#define ACID_WIDTH 1



/////////////// structs /////////////////
struct UserInput {
    Direction d;
    float mag;
};

/////////////// objects ///////////////
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad pad;
StarcraftEngine Starcraft;

///////////// prototypes ///////////////
void init();
void update_game(UserInput input);
void render();
void welcome();
void victory();
void gameover();
void background();
void score();

///////////// functions ////////////////
int main()
{
    int fps = 8;  // frames per second
    S1:init();     // initialise and then display welcome screen...
    welcome();  // waiting for the user to start
    background();  //introduce background story
    render();  // first draw the initial frame 
    wait(1.0f/fps);  // and wait for one frame period
    
    // game loop - read input, update the game state and render the display
    while(Starcraft.find_life() > 0) {
         Starcraft.read_input(pad);
         Starcraft.update(pad);
         render();
         wait(1.0f/fps);
         if (Starcraft.find_score() == 15) {
             break;
         }     
    }     
    
    score();
    if (Starcraft.find_score() == 15) {   // judge victory or fault
      victory();
      wait(1);
      goto S1;
    }  
      
    else{  
        gameover();
        wait(1);
        goto S1;
        }
}

// initialies all classes and libraries
void init()
{
     // need to initialise LCD and Gamepad 
     lcd.init();
     pad.init();
     
     // initialise the game with correct battleship, laser, boss and acid's sizes
     Starcraft.init(BATTLESHIP_HEIGHT, BATTLESHIP_WIDTH, LASER_HEIGHT, LASER_WIDTH,SWARM_HEIGHT, SWARM_WIDTH, BOSS_HEIGHT, BOSS_WIDTH, ACID_HEIGHT, ACID_WIDTH, SWARM_SPEED);
}

// this function draws each frame on the LCD
void render()
{
    // clear screen, re-draw and refresh
    lcd.clear();  
    Starcraft.draw(lcd);
    lcd.refresh();
}

// simple splash screen displayed on start-up
void welcome()
{
     lcd.printString("Starcraft!",0,1);  
     lcd.printString("Press Start",0,4);
     lcd.refresh();
     
     // wait flashing LEDs until start button is pressed 
     while ( pad.check_event(Gamepad::START_PRESSED) == false) {
           pad.leds_on();
           wait(0.1);
           pad.leds_off();
           wait(0.1);
     }
 
}

// introduce background story       
void background()
{
     lcd.clear(); 
     lcd.printString(" WARNING!!! ",1,1);
     lcd.printString(" WARNING!!! ",1,3);
     lcd.refresh();
     wait(2);
     
     lcd.clear(); 
     lcd.printString(" Swarm invide ",1,1);
     lcd.printString(" Our galaxy ",1,3);
     lcd.refresh();
     wait(2);
     
     lcd.clear(); 
     lcd.printString(" Our fleet ",1,1);
     lcd.printString(" Has been ",1,2);
     lcd.printString(" Destroyed ",2,3);
     lcd.refresh();
     wait(2);
     
     lcd.clear(); 
     lcd.printString(" You're the ",1,1);
     lcd.printString(" Last ",2,2);
     lcd.printString(" Battleship ",3,4);
     lcd.refresh();
     wait(2);
     
     lcd.clear(); 
     lcd.printString(" Kill them ",1,1);
     lcd.printString(" All!!! ",3,3);
     lcd.refresh();
     wait(2);
     
     lcd.clear(); 
     lcd.printString(" Good luck! ",2,2);
     lcd.refresh();
     wait(2);
}

// when game over the screen will display the score
void score()
{
    lcd.clear();  
    int battleship_score = Starcraft.find_score();
    char buffer3[14];
    sprintf(buffer3,"%2d",battleship_score);
    lcd.printString("SCORE",25 ,2);
    lcd.printString(buffer3,35 ,3);  // font is 8 wide, so leave 4 pixel gape from middle assuming two digits
    lcd.refresh();
    wait(1.5);
}

void victory()
{
    lcd.clear();
    lcd.printString(" Victory! ",1,1);
    lcd.printString(" You protect ",1,2);
    lcd.printString(" the earth! ",1,3);
    lcd.refresh();
    wait(2);
    
    lcd.clear();
    lcd.printString(" Press back ",1,1);
    lcd.printString(" to play again ",1,3);
    lcd.refresh();
     
    while ( pad.check_event(Gamepad::START_PRESSED) == false && pad.check_event(Gamepad::BACK_PRESSED) == false) {
          pad.leds_on();
          wait(0.1);
          pad.leds_off();
          wait(0.1);
    }
} 

void gameover()
{
    lcd.clear();
    lcd.printString(" You failed! ",1,1);
    lcd.printString(" Press back ",1,3);
    lcd.printString(" to play again ",1,4);
    lcd.refresh();
     
    while ( pad.check_event(Gamepad::START_PRESSED) == false && pad.check_event(Gamepad::BACK_PRESSED) == false) {
          pad.leds_on();
          wait(0.1);
          pad.leds_off();
          wait(0.1);
    }
} 