#include "StarcraftEngine.h"

StarcraftEngine::StarcraftEngine()
{
    
}

StarcraftEngine::~StarcraftEngine()
{
    
}

void StarcraftEngine::init(int Battleship_height, int Battleship_width, int Laser_height, int Laser_width, int Swarm_height, int Swarm_width,int Boss_height, int Boss_width, int Acid_height, int Acid_width, int speed)
{
     // initialise the game parameters
     _Battleship_height = Battleship_height;
     _Battleship_width = Battleship_width;
     _Laser_height = Laser_height;
     _Laser_width = Laser_width;
     _Swarm_height = Swarm_height;
     _Swarm_width = Swarm_width;
     _Boss_height = Boss_height;
     _Boss_width = Boss_width;
     _Acid_height = Acid_height;
     _Acid_width = Acid_width;
     _speed = speed;
     
     // x position on screen - WIDTH is defined in N5110.h
     _Battleshipx = GAP;
     
     // Initializing Battleship,Laser and Swarm
     _Battleship.init(_Battleshipx, _Battleship_height, _Battleship_width);
     _Laser.init(_Laser_height, _Laser_width, _speed);
     _Swarm.init(_Swarm_height, _Swarm_width, _speed);
     _Boss.init(_Boss_height, _Boss_width, _speed);
     _Acid.init(_Acid_height, _Acid_width, _speed);
     
}

void StarcraftEngine::read_input(Gamepad &pad)
{
    _d = pad.get_direction();
    _mag = pad.get_mag();
}     
 
int StarcraftEngine::find_life()  //get battleship's life
{   int find_life = _Battleship.get_life();
    return find_life;
} 

int StarcraftEngine::find_score()  //get player's score
{   int find_score = _Battleship.get_score();
    return find_score;
} 
 
void StarcraftEngine::draw(N5110 &lcd)
{
    // draw the elements in the LCD buffer
    // pitch
    lcd.drawRect(0,0,WIDTH,HEIGHT,FILL_TRANSPARENT);
    //score
    print_scores(lcd);
    // Battleship
    _Battleship.draw(lcd);
    // Swarm
    _Swarm.draw(lcd);
    // Boss
    _Boss.draw(lcd);
    // Laser
    _Laser.draw(lcd); 
    // Acid
    _Acid.draw(lcd);
    
}

void StarcraftEngine::update(Gamepad &pad)
{
     check_goal(pad);
     
     // important to update battleship, laser,boss and swarm before checking collisions so can
     // correct for it before updating the display
     
     _Battleship.update(_d,_mag);
     _Swarm.update();
     _Boss.update();
     _Laser.update();
     _Acid.update();
     
     check_Swarm_collisions(pad);
     check_Boss_collisions(pad);
     check_Battleship_collisions(pad);
}

void StarcraftEngine::check_Swarm_collisions(Gamepad &pad)  //check if the swarm over the bottom line and minus battleship life
{
     // read current swarm attributes
     Vector2D Swarm_pos = _Swarm.get_pos();
     Vector2D Swarm_velocity = _Swarm.get_velocity(); 

     // check if swarm over the battleship
     if (
          (Swarm_pos.y >= HEIGHT - 1) 
        )   {                 
         _Battleship.minus_life();
         Swarm_pos.x = rand() % 64;
         Swarm_pos.y = 2;
         pad.tone(800.0,0.1);  //  Audio feedback 
     }
     
     
     // write new attributes
    _Swarm.set_velocity(Swarm_velocity);
    _Swarm.set_pos(Swarm_pos);
} 

void StarcraftEngine::check_Boss_collisions(Gamepad &pad)  //check if the boss over the bottom line and minus battleship life
{
     // read current Boss attributes
     Vector2D Boss_pos = _Boss.get_pos();
     Vector2D Boss_velocity = _Boss.get_velocity(); 

     // check if Boss over the battleship
     if (
          (Boss_pos.y >= HEIGHT - 1) 
        )   {                 
         _Battleship.minus_life();
         Boss_pos.x = rand() % 65;
         Boss_pos.y = 2;
         pad.tone(800.0,0.1);  //  Audio feedback 
     }
     
     
     // write new attributes
    _Boss.set_velocity(Boss_velocity);
    _Boss.set_pos(Boss_pos);
} 

void StarcraftEngine::check_Battleship_collisions(Gamepad &pad)  //check if the acid hit the battleship and minus life   
{
     Vector2D Boss_pos = _Boss.get_pos();
     Vector2D Battleship_pos = _Battleship.get_pos();  
     Vector2D Acid_pos = _Acid.get_pos();
     
     Vector2D Acid_velocity = _Acid.get_velocity();
     Vector2D Boss_velocity = _Boss.get_velocity();
     
     // Player get score
     if ((Acid_pos.x >= Battleship_pos.x)&&
         (Acid_pos.x <= Battleship_pos.x + 6)&&
         (Acid_pos.y + 3 >= Battleship_pos.y)&&
         (Acid_pos.y <= Battleship_pos.y + 4))
     {
         _Battleship.minus_life();
         Acid_pos.x = Boss_pos.x + 3;
         Acid_pos.y = Boss_pos.y + 5; 
         pad.tone(800.0,0.1);  //  Audio feedback 
     }
     
      
     if ((Acid_pos.y > HEIGHT - 3)||(Acid_pos.y < 10))  //if acid over the bottom line, initialize acid's position
     {
        Acid_pos.x = Boss_pos.x + 3;
        Acid_pos.y = Boss_pos.y + 5; 
     }
     
      _Acid.set_velocity(Acid_velocity);
      _Boss.set_velocity(Boss_velocity);
      _Acid.set_pos(Acid_pos);   
      _Boss.set_pos(Boss_pos);  
}                  

void StarcraftEngine::check_goal(Gamepad &pad)  //check if the laser hit the swarn or boss and add score    
{
     Vector2D Swarm_pos = _Swarm.get_pos();
     Vector2D Boss_pos = _Boss.get_pos();
     Vector2D Battleship_pos = _Battleship.get_pos();  
     Vector2D Laser_pos = _Laser.get_pos();
     
     Vector2D Laser_velocity = _Laser.get_velocity();
     Vector2D Swarm_velocity = _Swarm.get_velocity();
     Vector2D Boss_velocity = _Boss.get_velocity();
     
     // Player get score
     if ((Laser_pos.x >= Swarm_pos.x)&&
         (Laser_pos.x <= Swarm_pos.x + 6)&&
         (Laser_pos.y <= Swarm_pos.y + 6)&&
         (Laser_pos.y >= Swarm_pos.y))
     {
         _Battleship.add_score();
         Laser_pos.x = Battleship_pos.x + 3;    
         Laser_pos.y = Battleship_pos.y - 1; 
         Swarm_pos.x = rand() % 64;
         Swarm_pos.y = 2;
         
         pad.tone(800.0,0.25);
         wait(0.1);
     }
     
     if ((Laser_pos.x >= Boss_pos.x)&&
         (Laser_pos.x <= Boss_pos.x + 6)&&
         (Laser_pos.y <= Boss_pos.y + 4)&&
         (Laser_pos.y >= Boss_pos.y))
     {
         _Battleship.add_score();
         Laser_pos.x = Battleship_pos.x + 3;    
         Laser_pos.y = Battleship_pos.y - 1; 
         Boss_pos.x = rand() % 64;
         Boss_pos.y = 2;
         
         pad.tone(800.0,0.25);
         wait(0.1);
     }
      
     if ((Laser_pos.y < 6)||(Battleship_pos.y - Laser_pos.y >= 20))  //set the laser's range and initialize laser's position
     {
            Laser_pos.x = Battleship_pos.x + 3;    
            Laser_pos.y = Battleship_pos.y - 1;  
     }
     
      _Laser.set_velocity(Laser_velocity);
      _Swarm.set_velocity(Swarm_velocity);
      _Boss.set_velocity(Boss_velocity);
      _Laser.set_pos(Laser_pos); 
      _Swarm.set_pos(Swarm_pos);    
      _Boss.set_pos(Boss_pos);  
}              
       
void StarcraftEngine::print_scores(N5110 &lcd)
{
     // get scores from battleship
     int Battleship_score = _Battleship.get_score();
     int Battleship_life = _Battleship.get_life();
     
     // print to LCD 
     char buffer1[14];
     sprintf(buffer1,"%2d",Battleship_score);
     lcd.printString("S",5,1);
     lcd.printString(buffer1,10,1);  // font is 8 wide, so leave 4 pixel gape from middle assuming two digits
     
     char buffer2[14];
    sprintf(buffer2,"%2d",Battleship_life);
    lcd.printString("L",WIDTH - 25,1);
    lcd.printString(buffer2,WIDTH - 20,1);
} 
 
 
 
     
     