#ifndef BATTLESHIP_H
#define BATTLESHIP_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Battleship Class  
* @brief Battleship 
* @author Haoyan Zhang  
* @date April, 2020 
*/ 

class Battleship
{
public:

       Battleship(); // Constructor
       
       ~Battleship(); // Destructor
       
       void init(int x,int height,int width); // Initialization
       
       void draw(N5110 &lcd); // Draw the pattern on lcd
       
       void update(Direction d,float mag); // Update the values
       
       void add_score(); // Add the score
       
       int get_score(); // Get the score
       
       Vector2D get_pos(); // Get the position
       
       void minus_life(); // Minus the life
       
       int get_life(); // Get the life

private:

       int _x;
       
       int _y;
       
       int _height;
       
       int _width;
       
       int _speed;
       
       int _score;
       
       int _life;
};
#endif
       
       
       
       
        