#ifndef STARCRAFTENGINE_H
#define STARCRAFTENGINE_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Battleship.h"
#include "Laser.h"
#include "Swarm.h"
#include "Boss.h"
#include "Acid.h"

// gap from edge of screen
#define GAP 2

/** StarcraftEngine Class  
@brief StarcraftEngine  
@author Haoyan Zhang  
@date May, 2020 
*/ 


class StarcraftEngine
{
    
public:
       StarcraftEngine();
       ~StarcraftEngine();
       
       void init(int Battleship_height, int Battleship_width, int Laser_height, int Laser_width, int Swarm_height, int Swarm_width,int Boss_height, int Boss_width, int Acid_height, int Acid_width,int speed);
       void read_input(Gamepad &pad);
       int find_life();
       int find_score();
       void draw(N5110 &lcd);
       void update(Gamepad &pad);
       
private:
        void check_Swarm_collisions(Gamepad &pad);
        void check_Boss_collisions(Gamepad &pad);
        void check_Battleship_collisions(Gamepad &pad);
        void check_goal(Gamepad &pad);
        void print_scores(N5110 &lcd);
        
        Battleship _Battleship;
        int _Battleship_height;
        int _Battleship_width;
        int _speed;
        // x positions of the Battleship
        int _Battleshipx;
        
        
        Laser _Laser;
        int _Laser_height;
        int _Laser_width;
        
        Swarm _Swarm;
        int _Swarm_height;
        int _Swarm_width;
        
        Boss _Boss;
        int _Boss_height;
        int _Boss_width;
        
        Acid _Acid;
        int _Acid_height;
        int _Acid_width;
        
        Direction _d;
        float _mag;
};
#endif        
        
        
        
        
        
        
                   